/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;

public class Boom
extends Ability {
    private boolean instantKill;
    private float explosionSize;
    private boolean causesFire;
    public static final Codec<Boom> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("instant_kill", (Object)true).forGetter(Boom::isInstantKill), (App)Codec.BOOL.optionalFieldOf("causes_fire", (Object)false).forGetter(Boom::causesFire), (App)Codec.FLOAT.optionalFieldOf("explosion_size", (Object)Float.valueOf(7.0f)).forGetter(Boom::getExplosionSize)).apply((Applicative)instance, Boom::new));

    public Boom(boolean instantKill, boolean causesFire, float explosionSize) {
        this.instantKill = instantKill;
        this.causesFire = causesFire;
        this.explosionSize = explosionSize;
    }

    public float getExplosionSize() {
        return this.explosionSize;
    }

    public boolean causesFire() {
        return this.causesFire;
    }

    public boolean isInstantKill() {
        return this.instantKill;
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (!player.m_7500_() && player.f_19797_ > 80) {
            if (this.isInstantKill()) {
                player.m_6469_(DamageSource.m_19373_((LivingEntity)player), 69420.0f);
            }
            player.f_19853_.m_7703_((Entity)player, DamageSource.m_19373_((LivingEntity)player), (ExplosionDamageCalculator)new EntityBasedExplosionDamageCalculator((Entity)player), player.m_20185_(), player.m_20186_(), player.m_20189_(), this.explosionSize, this.causesFire, Explosion.BlockInteraction.BREAK);
            Random rand = new Random();
            Level playerWorld = player.f_19853_;
            for (int i = 0; i < 2; ++i) {
                playerWorld.m_5594_(null, player.m_142538_().m_142082_(rand.nextInt(21) - 10, rand.nextInt(21) - 10, rand.nextInt(21) - 10), rand.nextBoolean() ? SoundEvents.f_11892_ : SoundEvents.f_11913_, SoundSource.MASTER, 20.0f, rand.nextFloat() - 0.6f + 1.0f);
            }
        }
    }
}

