/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.bossbar.BossbarCapabilityInstance;
import de.budschie.bmorph.events.Events;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import java.util.List;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;

public class BossbarAbility
extends Ability {
    public static final Codec<BossbarAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.BOSSBAR_COLOR_ENUM.fieldOf("bossbar_color").forGetter(BossbarAbility::getBossbarColor), (App)ModCodecs.BOSSBAR_OVERLAY_ENUM.fieldOf("bossbar_overlay").forGetter(BossbarAbility::getBossbarOverlay), (App)Codec.BOOL.optionalFieldOf("darken_world", (Object)false).forGetter(BossbarAbility::isDarkenWorld), (App)Codec.BOOL.optionalFieldOf("create_world_fog", (Object)false).forGetter(BossbarAbility::isCreateWorldFog), (App)Codec.BOOL.optionalFieldOf("play_boss_music", (Object)false).forGetter(BossbarAbility::isPlayBossMusic)).apply((Applicative)instance, BossbarAbility::new));
    private BossEvent.BossBarColor bossbarColor;
    private BossEvent.BossBarOverlay bossbarOverlay;
    private boolean darkenWorld;
    private boolean createWorldFog;
    private boolean playBossMusic;

    public BossbarAbility(BossEvent.BossBarColor bossbarColor, BossEvent.BossBarOverlay bossbarOverlay, boolean darkenWorld, boolean createWorldFog, boolean playBossMusic) {
        this.bossbarColor = bossbarColor;
        this.bossbarOverlay = bossbarOverlay;
        this.darkenWorld = darkenWorld;
        this.createWorldFog = createWorldFog;
        this.playBossMusic = playBossMusic;
    }

    @Override
    public void enableAbility(Player player, MorphItem enabledItem, MorphItem oldMorph, List<Ability> oldAbilities, Ability.AbilityChangeReason reason) {
        super.enableAbility(player, enabledItem, oldMorph, oldAbilities, reason);
        if (!player.f_19853_.m_5776_()) {
            ServerBossEvent bossbar = (ServerBossEvent)new ServerBossEvent(player.m_5446_(), this.bossbarColor, this.bossbarOverlay).m_7006_(this.createWorldFog).m_7003_(this.darkenWorld).m_7005_(this.playBossMusic);
            player.getCapability(BossbarCapabilityInstance.BOSSBAR_CAP).ifPresent(cap -> cap.setBossbar(bossbar));
            Events.showBossbarToEveryoneTrackingPlayer(player);
        }
    }

    @Override
    public void disableAbility(Player player, MorphItem disabledItem, MorphItem newMorph, List<Ability> newAbilities, Ability.AbilityChangeReason reason) {
        super.disableAbility(player, disabledItem, newMorph, newAbilities, reason);
        if (!player.f_19853_.m_5776_()) {
            player.getCapability(BossbarCapabilityInstance.BOSSBAR_CAP).ifPresent(cap -> cap.clearBossbar());
        }
    }

    public BossEvent.BossBarColor getBossbarColor() {
        return this.bossbarColor;
    }

    public BossEvent.BossBarOverlay getBossbarOverlay() {
        return this.bossbarOverlay;
    }

    public boolean isDarkenWorld() {
        return this.darkenWorld;
    }

    public boolean isCreateWorldFog() {
        return this.createWorldFog;
    }

    public boolean isPlayBossMusic() {
        return this.playBossMusic;
    }
}

