/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.functionality.Ability;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BurnInSunAbility
extends Ability {
    public static final Codec<BurnInSunAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("burn_time").forGetter(BurnInSunAbility::getBurnTime), (App)Codec.BOOL.optionalFieldOf("ignore_hat", (Object)false).forGetter(BurnInSunAbility::isIgnoringHat), (App)Codec.INT.optionalFieldOf("max_armor_damage", (Object)2).forGetter(BurnInSunAbility::getMaxArmorDamage)).apply((Applicative)instance, BurnInSunAbility::new));
    private int burnTime;
    private boolean ignoreHat;
    private int maxArmorDamage;

    public BurnInSunAbility(int burnTime, boolean ignoreHat, int maxArmorDamage) {
        this.burnTime = burnTime;
        this.ignoreHat = ignoreHat;
        this.maxArmorDamage = maxArmorDamage;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean isIgnoringHat() {
        return this.ignoreHat;
    }

    public int getMaxArmorDamage() {
        return this.maxArmorDamage;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        for (UUID playerId : this.trackedPlayers) {
            boolean shallBeImmuneToFire;
            ServerPlayer player = ServerSetup.server.m_6846_().m_11259_(playerId);
            if (player.m_20147_() || player.f_19853_.f_46443_ || !player.f_19853_.m_46461_() || player.f_19853_.f_46443_) continue;
            float currentBrightness = player.m_6073_();
            BlockPos blockpos = new BlockPos(player.m_146892_());
            boolean bl = shallBeImmuneToFire = player.m_20071_() || player.f_146808_ || player.f_146809_;
            if (!(currentBrightness > 0.5f) || !(player.m_21187_().nextFloat() * 30.0f < (currentBrightness - 0.4f) * 2.0f) || shallBeImmuneToFire || !player.f_19853_.m_45527_(blockpos)) continue;
            ItemStack hatItem = player.m_6844_(EquipmentSlot.HEAD);
            if (!this.ignoreHat && !hatItem.m_41619_()) {
                hatItem.m_41721_(hatItem.m_41773_() + player.m_21187_().nextInt(this.maxArmorDamage));
                if (hatItem.m_41773_() >= hatItem.m_41776_()) {
                    player.m_21166_(EquipmentSlot.HEAD);
                    player.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                }
                return;
            }
            player.m_20254_(this.burnTime);
        }
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

