/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.budschie.bmorph.morph.functionality.Ability;
import java.text.MessageFormat;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurableAbility<A extends Ability>
extends ForgeRegistryEntry<ConfigurableAbility<? extends Ability>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private Codec<A> codec;

    public ConfigurableAbility(Codec<A> codec) {
        this.codec = codec;
    }

    public Codec<A> getCodec() {
        return this.codec;
    }

    public Optional<Ability> deserialize(JsonElement object) {
        Optional optAbility = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)object).resultOrPartial(err -> LOGGER.warn("Received bad data when parsing configurable ability: " + err));
        optAbility.ifPresent(p -> ((Ability)p.getFirst()).setConfigurableAbility(this));
        return optAbility.isPresent() ? Optional.of((Ability)((Pair)optAbility.get()).getFirst()) : Optional.empty();
    }

    public Optional<Ability> deserializeNBT(CompoundTag nbt) {
        Optional optAbility = this.codec.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(err -> LOGGER.warn("Could not parse ability data from NBT: " + err));
        optAbility.ifPresent(p -> ((Ability)p.getFirst()).setConfigurableAbility(this));
        return optAbility.isPresent() ? Optional.of((Ability)((Pair)optAbility.get()).getFirst()) : Optional.empty();
    }

    public Optional<CompoundTag> serializeNBT(A ability) {
        DataResult nbt = this.getCodec().encodeStart((DynamicOps)NbtOps.f_128958_, ability);
        if (nbt.get().left().isPresent()) {
            if (nbt.get().left().get() instanceof CompoundTag) {
                return Optional.of((CompoundTag)nbt.get().left().get());
            }
            return Optional.of(new CompoundTag());
        }
        LOGGER.warn(MessageFormat.format("There was an error serializing the ability {0} with its codec {1}: {2}", ((Ability)ability).getResourceLocation(), this.getRegistryName(), ((DataResult.PartialResult)nbt.get().right().get()).message()));
        return Optional.empty();
    }

    public Optional<CompoundTag> serializeNBTIAmTooDumbForJava(Ability ability) {
        if (ability.getConfigurableAbility() == this) {
            return this.serializeNBT(ability);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }

    public boolean equals(Object obj) {
        ConfigurableAbility otherConfigAbility;
        return obj instanceof ConfigurableAbility && (otherConfigAbility = (ConfigurableAbility)((Object)obj)).getRegistryName().equals((Object)this.getRegistryName());
    }

    public static class SerializationResult {
    }
}

