/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CowMilkAbility
extends Ability {
    public static final Codec<CowMilkAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("food_level_cost").forGetter(CowMilkAbility::getFoodLevelCost), (App)Codec.INT.fieldOf("required_food_level_to_milk").forGetter(CowMilkAbility::getRequiredMilkFoodLevel), (App)AudioVisualEffect.CODEC.optionalFieldOf("drink_milk_self_effect").forGetter(CowMilkAbility::getDrinkMilkSelfEffect), (App)AudioVisualEffect.CODEC.optionalFieldOf("milker_entity_effect").forGetter(CowMilkAbility::getMilkerEntityEffect), (App)AudioVisualEffect.CODEC.optionalFieldOf("milked_entity_effect").forGetter(CowMilkAbility::getMilkedEntityEffect), (App)AudioVisualEffect.CODEC.optionalFieldOf("not_enough_food_feedback_effect").forGetter(CowMilkAbility::getNotEnoughFoodFeedbackEffect)).apply((Applicative)instance, CowMilkAbility::new));
    private int foodLevelCost;
    private int requiredMilkFoodLevel;
    private Optional<AudioVisualEffect> drinkMilkSelfEffect;
    private Optional<AudioVisualEffect> milkerEntityEffect;
    private Optional<AudioVisualEffect> milkedEntityEffect;
    private Optional<AudioVisualEffect> notEnoughFoodFeedbackEffect;

    public CowMilkAbility(int foodLevelCost, int requiredMilkFoodLevel, Optional<AudioVisualEffect> drinkMilkSelfEffect, Optional<AudioVisualEffect> milkerEntityEffect, Optional<AudioVisualEffect> milkedEntityEffect, Optional<AudioVisualEffect> notEnoughFoodFeedbackEffect) {
        this.foodLevelCost = foodLevelCost;
        this.requiredMilkFoodLevel = requiredMilkFoodLevel;
        this.drinkMilkSelfEffect = drinkMilkSelfEffect;
        this.milkerEntityEffect = milkerEntityEffect;
        this.milkedEntityEffect = milkedEntityEffect;
        this.notEnoughFoodFeedbackEffect = notEnoughFoodFeedbackEffect;
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (player.m_21220_().size() > 0) {
            if (this.canMilk(player)) {
                this.drinkMilkSelfEffect.ifPresent(effect -> effect.playEffect((Entity)player));
                this.decrementHungerAndSaturation(player);
                player.m_21219_();
            } else {
                this.notEnoughFoodFeedbackEffect.ifPresent(ave -> ave.playEffect((Entity)player));
            }
        }
    }

    @SubscribeEvent
    public void onGettingInteractedWith(PlayerInteractEvent.EntityInteract event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && !event.getWorld().m_5776_() && this.isTracked(event.getTarget()) && event.getItemStack().m_150930_(Items.f_42446_)) {
            if (this.canMilk((Player)event.getTarget())) {
                this.milkerEntityEffect.ifPresent(effect -> effect.playEffect(event.getEntity()));
                this.milkedEntityEffect.ifPresent(effect -> effect.playEffect(event.getTarget()));
                ItemStack milkStack = ItemUtils.m_41813_((ItemStack)event.getItemStack(), (Player)event.getPlayer(), (ItemStack)Items.f_42455_.m_7968_());
                this.decrementHungerAndSaturation((Player)event.getTarget());
                event.getPlayer().m_21008_(event.getHand(), milkStack);
            } else {
                this.notEnoughFoodFeedbackEffect.ifPresent(ave -> ave.playEffect(event.getTarget()));
            }
        }
    }

    private void decrementHungerAndSaturation(Player player) {
        player.m_36324_().m_38717_(0.0f);
        player.m_36324_().m_38705_(Math.max(player.m_36324_().m_38702_() - this.foodLevelCost, 0));
    }

    private boolean canMilk(Player player) {
        return player.m_36324_().m_38702_() >= this.requiredMilkFoodLevel;
    }

    public int getFoodLevelCost() {
        return this.foodLevelCost;
    }

    public int getRequiredMilkFoodLevel() {
        return this.requiredMilkFoodLevel;
    }

    public Optional<AudioVisualEffect> getDrinkMilkSelfEffect() {
        return this.drinkMilkSelfEffect;
    }

    public Optional<AudioVisualEffect> getMilkerEntityEffect() {
        return this.milkerEntityEffect;
    }

    public Optional<AudioVisualEffect> getMilkedEntityEffect() {
        return this.milkedEntityEffect;
    }

    public Optional<AudioVisualEffect> getNotEnoughFoodFeedbackEffect() {
        return this.notEnoughFoodFeedbackEffect;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

