/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.StunAbility;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class DisableMorphItem
extends StunAbility {
    public static final Codec<DisableMorphItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("time_until_demorph").forGetter(DisableMorphItem::getMaxMorphTime), (App)Codec.INT.optionalFieldOf("disable_morph_for").forGetter(DisableMorphItem::getDisableEntityTime), (App)WarningEffect.CODEC.listOf().optionalFieldOf("warning_effects", Arrays.asList(new WarningEffect[0])).forGetter(DisableMorphItem::getWarningEffects)).apply((Applicative)instance, DisableMorphItem::new));
    private Optional<Integer> disableEntityTime;
    private Optional<Integer> maxMorphTime;
    private List<WarningEffect> warningEffects;

    public DisableMorphItem(Optional<Integer> maxMorphTime, Optional<Integer> disableEntityTime, List<WarningEffect> warningEffects) {
        super(69);
        this.disableEntityTime = disableEntityTime;
        this.maxMorphTime = maxMorphTime;
        this.warningEffects = warningEffects;
    }

    public List<WarningEffect> getWarningEffects() {
        return this.warningEffects;
    }

    public Optional<Integer> getDisableEntityTime() {
        return this.disableEntityTime;
    }

    public Optional<Integer> getMaxMorphTime() {
        return this.maxMorphTime;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return this.maxMorphTime.isPresent();
    }

    @Override
    public void enableAbility(Player player, MorphItem enabledItem, MorphItem oldMorph, List<Ability> oldAbilities, Ability.AbilityChangeReason reason) {
        super.enableAbility(player, enabledItem, oldMorph, oldAbilities, reason);
        this.disableEntityTime.ifPresent(timeToDisableEntity -> enabledItem.disable((int)timeToDisableEntity));
        this.maxMorphTime.ifPresent(timeUntilUnmorph -> this.stun(player.m_142081_(), (int)timeUntilUnmorph));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        UUID[] trackedPlayersClone;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        for (UUID uuid : trackedPlayersClone = (UUID[])this.trackedPlayers.toArray(UUID[]::new)) {
            ServerPlayer player = ServerSetup.server.m_6846_().m_11259_(uuid);
            int timeLeft = this.getStunTimeLeftFor((Player)player);
            this.warningEffects.forEach(arg_0 -> DisableMorphItem.lambda$onServerTick$4((Player)player, timeLeft, arg_0));
            if (this.isCurrentlyStunned(uuid)) continue;
            MorphUtil.morphToServer(Optional.empty(), Optional.empty(), (Player)player);
        }
    }

    private static /* synthetic */ void lambda$onServerTick$4(Player player, int timeLeft, WarningEffect effect) {
        effect.applyWarning(player, timeLeft);
    }

    public static class WarningEffect {
        public static Codec<WarningEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("ticks_left").forGetter(WarningEffect::getTicksLeft), (App)ModCodecs.EFFECT_INSTANCE.listOf().optionalFieldOf("mob_effects", Arrays.asList(new MobEffectInstance[0])).forGetter(WarningEffect::getMobEffects), (App)AudioVisualEffect.CODEC.optionalFieldOf("audiovisual_effect").forGetter(WarningEffect::getAudioVisualEffect)).apply((Applicative)instance, WarningEffect::new));
        private int ticksLeft;
        private List<MobEffectInstance> mobEffects;
        private Optional<AudioVisualEffect> audioVisualEffect;

        public WarningEffect(int ticksLeft, List<MobEffectInstance> mobEffects, Optional<AudioVisualEffect> audioVisualEffect) {
            this.ticksLeft = ticksLeft;
            this.mobEffects = mobEffects;
            this.audioVisualEffect = audioVisualEffect;
        }

        public void applyWarning(Player player, int ticksLeft) {
            if (this.ticksLeft == ticksLeft) {
                this.mobEffects.forEach(mobEffect -> player.m_7292_(new MobEffectInstance(mobEffect)));
                this.audioVisualEffect.ifPresent(ave -> ave.playEffect((Entity)player));
            }
        }

        public int getTicksLeft() {
            return this.ticksLeft;
        }

        public List<MobEffectInstance> getMobEffects() {
            return this.mobEffects;
        }

        public Optional<AudioVisualEffect> getAudioVisualEffect() {
            return this.audioVisualEffect;
        }
    }
}

