/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.AbilitySerializationContext;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.network.Flight;
import de.budschie.bmorph.network.MainNetworkChannel;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class FlyAbility
extends Ability {
    public static final Codec<FlyAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("flying_speed", (Object)Float.valueOf(0.05f)).forGetter(FlyAbility::getFlyingSpeed)).apply((Applicative)instance, FlyAbility::new));
    private float flyingSpeed;

    public FlyAbility(float flyingSpeed) {
        this.flyingSpeed = flyingSpeed;
    }

    @Override
    public void enableAbility(Player player, MorphItem enabledItem, MorphItem oldMorph, List<Ability> oldAbilities, Ability.AbilityChangeReason reason) {
        super.enableAbility(player, enabledItem, oldMorph, oldAbilities, reason);
        player.m_150110_().f_35936_ = true;
        player.m_150110_().m_35943_(this.flyingSpeed);
    }

    @Override
    public void disableAbility(Player player, MorphItem disabledItem, MorphItem newMorph, List<Ability> newAbilities, Ability.AbilityChangeReason reason) {
        super.disableAbility(player, disabledItem, newMorph, newAbilities, reason);
        boolean mayStillFly = false;
        for (Ability ability : newAbilities) {
            if (!(ability instanceof FlyAbility)) continue;
            mayStillFly = true;
            break;
        }
        if (!(player.m_7500_() || player.m_5833_() || mayStillFly)) {
            player.m_150110_().f_35936_ = false;
            player.m_150110_().f_35935_ = false;
        }
        player.m_150110_().m_35943_(0.05f);
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.trackedPlayers.contains(event.player.m_142081_())) {
            if (event.player.m_150110_().f_35935_) {
                event.player.m_20124_(Pose.STANDING);
                event.player.setForcedPose(null);
                if (event.player.m_7500_() || event.player.m_5833_()) {
                    event.player.m_150110_().m_35943_(0.05f);
                } else {
                    event.player.m_150110_().m_35943_(this.flyingSpeed);
                }
            }
            if (!event.player.m_150110_().f_35936_) {
                event.player.m_150110_().f_35936_ = true;
            }
        }
    }

    @Override
    public void serialize(Player player, AbilitySerializationContext context, boolean canSaveTransientData) {
        super.serialize(player, context, canSaveTransientData);
        if (canSaveTransientData) {
            context.getOrCreateSerializationObjectForAbility(this).createTransientTag().m_128379_("player_flying", player.m_150110_().f_35935_);
        }
    }

    @Override
    public void deserialize(Player player, AbilitySerializationContext context) {
        super.deserialize(player, context);
        AbilitySerializationContext.AbilitySerializationObject object = context.getSerializationObjectForAbilityOrNull(this);
        if (object != null && object.getTransientTag().isPresent() && object.getTransientTag().get().m_128441_("player_flying")) {
            player.m_150110_().f_35935_ = player.m_150110_().f_35935_ || object.getTransientTag().get().m_128471_("player_flying");
            MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new Flight.FlightPacket(player.m_150110_().f_35935_));
        }
    }

    public float getFlyingSpeed() {
        return this.flyingSpeed;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

