/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.guardian.GuardianBeamCapabilityHandler;
import de.budschie.bmorph.capabilities.guardian.GuardianBeamCapabilityInstance;
import de.budschie.bmorph.capabilities.guardian.IGuardianBeamCapability;
import de.budschie.bmorph.events.GuardianAbilityStatusUpdateEvent;
import de.budschie.bmorph.events.PlayerMorphEvent;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.configurable.client.GuardianClientAdapter;
import de.budschie.bmorph.morph.functionality.configurable.client.GuardianClientAdapterInstance;
import de.budschie.bmorph.util.SoundInstance;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;

public class GuardianAbility
extends Ability {
    public static final Codec<GuardianAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("damage").forGetter(GuardianAbility::getDamage), (App)Codec.BOOL.optionalFieldOf("may_move", (Object)false).forGetter(GuardianAbility::mayMove), (App)Codec.BOOL.optionalFieldOf("may_cancel", (Object)false).forGetter(GuardianAbility::mayCancel), (App)Codec.BOOL.optionalFieldOf("may_xray", (Object)false).forGetter(GuardianAbility::mayXray), (App)Codec.INT.optionalFieldOf("attack_duration", (Object)80).forGetter(GuardianAbility::getAttackDuration), (App)Codec.DOUBLE.fieldOf("max_distance_to_target").forGetter(GuardianAbility::getMaxDistance), (App)SoundInstance.CODEC.optionalFieldOf("cancel_ability_sound").forGetter(GuardianAbility::getCancelAbilitySound), (App)SoundInstance.CODEC.optionalFieldOf("successful_attack_sound").forGetter(GuardianAbility::getSuccessfullyAttackedSound)).apply((Applicative)instance, GuardianAbility::new));
    private float damage;
    private boolean mayMove;
    private boolean mayCancel;
    private boolean xray;
    private double maxDistance;
    private int attackDuration;
    private Optional<SoundInstance> cancelAbilitySound;
    private Optional<SoundInstance> successfullyAttackedSound;
    private AttributeModifier am = new AttributeModifier(UUID.fromString("6605b0e2-98bf-4406-b7e7-39fa26ca9895"), "no movement guardian", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private GuardianClientAdapter adapter;

    public GuardianAbility(float damage, boolean mayMove, boolean mayCancel, boolean xray, int attackDuration, double maxDistance, Optional<SoundInstance> cancelAbilitySound, Optional<SoundInstance> successfullyAtackedSound) {
        this.damage = damage;
        this.mayMove = mayMove;
        this.mayCancel = mayCancel;
        this.xray = xray;
        this.attackDuration = attackDuration;
        this.cancelAbilitySound = cancelAbilitySound;
        this.successfullyAttackedSound = successfullyAtackedSound;
        this.maxDistance = maxDistance;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> GuardianClientAdapterInstance.createInstance(adapter -> {
            this.adapter = adapter;
        }, entity -> this.isTracked((Entity)entity)));
    }

    public float getDamage() {
        return this.damage;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    public boolean mayMove() {
        return this.mayMove;
    }

    public boolean mayCancel() {
        return this.mayCancel;
    }

    public boolean mayXray() {
        return this.xray;
    }

    public int getAttackDuration() {
        return this.attackDuration;
    }

    public Optional<SoundInstance> getCancelAbilitySound() {
        return this.cancelAbilitySound;
    }

    public Optional<SoundInstance> getSuccessfullyAttackedSound() {
        return this.successfullyAttackedSound;
    }

    @Override
    public void onRegister() {
        super.onRegister();
        if (this.adapter != null) {
            this.adapter.enableAdapter();
        }
    }

    @Override
    public void onUnregister() {
        super.onUnregister();
        if (this.adapter != null) {
            this.adapter.disableAdapter();
        }
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (!player.f_19853_.f_46443_) {
            if (this.isAbilityActive(player)) {
                if (this.mayCancel) {
                    this.cancelAbilitySound.ifPresent(sound -> sound.playSoundAt((Entity)player));
                    GuardianBeamCapabilityHandler.INSTANCE.unattackServer(player);
                    this.deapplyAbilityEffects(player);
                }
            } else {
                BlockHitResult blockResult;
                AABB aabb;
                Vec3 to;
                Vec3 from = player.m_20182_().m_82549_(Vec3.m_82503_((Vec2)player.m_20155_())).m_82520_(0.0, (double)player.m_20192_(), 0.0);
                EntityHitResult result = ProjectileUtil.m_37304_((Level)player.f_19853_, (Entity)player, (Vec3)from, (Vec3)(to = Vec3.m_82503_((Vec2)player.m_20155_()).m_82542_(this.maxDistance, this.maxDistance, this.maxDistance).m_82549_(from)), (AABB)(aabb = new AABB(from, to)), entity -> entity instanceof LivingEntity);
                if (result != null && ((blockResult = player.f_19853_.m_45547_(new ClipContext(from, result.m_82443_().m_20182_().m_82520_(0.0, (double)result.m_82443_().m_20192_(), 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null))) == null || blockResult.m_6662_() == HitResult.Type.MISS && !this.isEntityOutOfRange(player, result.m_82443_()))) {
                    GuardianBeamCapabilityHandler.INSTANCE.attackServer(player, result.m_82443_(), this.getAttackDuration());
                    this.applyAbilityEffects(player);
                }
            }
        }
    }

    private boolean isEntityOutOfRange(Player ofPlayer, Entity entity) {
        return entity.m_20182_().m_82557_(ofPlayer.m_20182_()) > this.maxDistance * this.maxDistance;
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (this.isTracked(event.getEntity()) && this.isAbilityActive((Player)event.getEntity()) && !this.mayMove) {
            event.getEntityLiving().m_20334_(event.getEntityLiving().m_20184_().f_82479_, 0.0, event.getEntityLiving().m_20184_().f_82481_);
        }
    }

    @SubscribeEvent
    public void onGuardianStatusUpdate(GuardianAbilityStatusUpdateEvent event) {
        if (this.isTracked((Entity)event.getPlayer()) && !event.getPlayer().f_19853_.f_46443_) {
            Vec3 to;
            Vec3 from;
            BlockHitResult blockResult;
            if (event.isInvalidated()) {
                this.deapplyAbilityEffects(event.getPlayer());
                return;
            }
            Entity targettedEntity = ((ServerLevel)event.getPlayer().f_19853_).m_8791_(event.getCapability().getAttackedEntityServer().get());
            if (targettedEntity == null || !targettedEntity.m_6084_() || targettedEntity.m_146910_() || this.isEntityOutOfRange(event.getPlayer(), targettedEntity)) {
                GuardianBeamCapabilityHandler.INSTANCE.unattackServer(event.getPlayer());
                return;
            }
            if (!this.xray && (blockResult = event.getPlayer().f_19853_.m_45547_(new ClipContext(from = event.getPlayer().m_20182_().m_82549_(Vec3.m_82503_((Vec2)event.getPlayer().m_20155_())).m_82520_(0.0, (double)event.getPlayer().m_20192_(), 0.0), to = targettedEntity.m_20182_().m_82520_(0.0, (double)targettedEntity.m_20192_(), 0.0), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)event.getPlayer()))) != null && blockResult.m_6662_() == HitResult.Type.BLOCK) {
                GuardianBeamCapabilityHandler.INSTANCE.unattackServer(event.getPlayer());
                return;
            }
            if (event.getCapability().getAttackProgression() >= this.attackDuration) {
                Entity currentlyTargettedEntity = ((ServerLevel)event.getPlayer().f_19853_).m_8791_(event.getCapability().getAttackedEntityServer().get());
                currentlyTargettedEntity.m_6469_(DamageSource.m_19367_((Entity)event.getPlayer(), (Entity)event.getPlayer()), this.damage);
                GuardianBeamCapabilityHandler.INSTANCE.unattackServer(event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onMorphingServerEvent(PlayerMorphEvent.Server.Pre event) {
        if (this.isTracked((Entity)event.getPlayer()) && this.isAbilityActive(event.getPlayer()) && !this.mayCancel) {
            event.setCanceled(true);
        }
    }

    private void applyAbilityEffects(Player player) {
        if (!this.mayMove && !player.f_19853_.f_46443_) {
            player.m_21051_(Attributes.f_22279_).m_22118_(this.am);
        }
    }

    private void deapplyAbilityEffects(Player player) {
        AttributeInstance inst;
        if (!this.mayMove && !player.f_19853_.f_46443_ && (inst = player.m_21051_(Attributes.f_22279_)).m_22109_(this.am)) {
            inst.m_22130_(this.am);
        }
    }

    @Override
    public void enableAbility(Player player, MorphItem enabledItem, MorphItem oldMorph, List<Ability> oldAbilities, Ability.AbilityChangeReason reason) {
        super.enableAbility(player, enabledItem, oldMorph, oldAbilities, reason);
        if (this.adapter != null && player.f_19853_.f_46443_) {
            this.adapter.playGuardianSound(player);
        }
    }

    @Override
    public void disableAbility(Player player, MorphItem disabledItem, MorphItem newMorph, List<Ability> newAbilities, Ability.AbilityChangeReason reason) {
        super.disableAbility(player, disabledItem, newMorph, newAbilities, reason);
        if (!player.f_19853_.f_46443_) {
            IGuardianBeamCapability cap = this.getNullableBeamCap(player);
            if (cap != null && cap.getAttackedEntity().isPresent()) {
                GuardianBeamCapabilityHandler.INSTANCE.unattackServer(player);
            }
            this.deapplyAbilityEffects(player);
        }
    }

    private boolean isAbilityActive(Player player) {
        IGuardianBeamCapability cap = this.getNullableBeamCap(player);
        if (cap == null) {
            return false;
        }
        return cap.getAttackedEntity().isPresent();
    }

    private IGuardianBeamCapability getNullableBeamCap(Player player) {
        return player.getCapability(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP).resolve().orElse(null);
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

