/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.LazyRegistryWrapper;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import de.budschie.bmorph.util.BudschieUtils;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ImmuneToDamageIfAbility
extends Ability {
    public static final Codec<ImmuneToDamageIfAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.PREDICATE.listOf().listOf().fieldOf("predicates").forGetter(ImmuneToDamageIfAbility::getPredicates)).apply((Applicative)instance, ImmuneToDamageIfAbility::new));
    private List<List<LazyRegistryWrapper<LootItemCondition>>> predicates;

    public ImmuneToDamageIfAbility(List<List<LazyRegistryWrapper<LootItemCondition>>> predicates) {
        this.predicates = predicates;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        LootContext.Builder predicateContext;
        if (event.getEntity().f_19853_.m_5776_() || !this.isTracked(event.getEntity())) {
            return;
        }
        Player player = (Player)event.getEntity();
        LootItemCondition[][] resolved = BudschieUtils.resolveConditions(this.predicates);
        if (BudschieUtils.testPredicates(resolved, () -> ImmuneToDamageIfAbility.lambda$onPlayerAttacked$1(predicateContext = new LootContext.Builder((ServerLevel)player.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)event.getSource()).m_78984_(LootContextParams.f_81455_, (Object)player)))) {
            event.setCanceled(true);
        }
    }

    public List<List<LazyRegistryWrapper<LootItemCondition>>> getPredicates() {
        return this.predicates;
    }

    private static /* synthetic */ LootContext lambda$onPlayerAttacked$1(LootContext.Builder predicateContext) {
        return predicateContext.m_78975_(LootContextParamSets.f_81415_);
    }
}

