/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.fallback.FallbackMorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import de.budschie.bmorph.morph.functionality.configurable.TransformEntityOnDeath;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class MorphAbility
extends Ability {
    public static final Codec<MorphMode> MORPH_MODE_CODEC = ModCodecs.getEnumCodec(MorphMode.class, MorphMode::values);
    public static final Codec<MorphAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MORPH_MODE_CODEC.fieldOf("morph_mode").forGetter(MorphAbility::getMorphMode), (App)ModCodecs.ENTITIES.fieldOf("entity_to_morph_to").forGetter(MorphAbility::getEntityToMorphTo), (App)TransformEntityOnDeath.NbtMappings.CODEC.listOf().optionalFieldOf("nbt_mappings", Arrays.asList(new TransformEntityOnDeath.NbtMappings[0])).forGetter(MorphAbility::getNbtMappings), (App)ModCodecs.DATA_TRANSFORMER.listOf().optionalFieldOf("data_transformers", Arrays.asList(new LazyOptional[0])).forGetter(MorphAbility::getDataTransformers), (App)AudioVisualEffect.CODEC.optionalFieldOf("effect_on_morph").forGetter(MorphAbility::getEffectOnMorph), (App)ModCodecs.NBT_COMPOUND_TAG.optionalFieldOf("default_nbt", (Object)new CompoundTag()).forGetter(MorphAbility::getDefaultNbt)).apply((Applicative)instance, MorphAbility::new));
    private MorphMode morphMode;
    private EntityType<?> entityToMorphTo;
    private List<TransformEntityOnDeath.NbtMappings> nbtMappings;
    private List<LazyOptional<DataTransformer>> dataTransformers;
    private Optional<AudioVisualEffect> effectOnMorph;
    private CompoundTag defaultNbt;

    public MorphAbility(MorphMode morphMode, EntityType<?> entityToMorphTo, List<TransformEntityOnDeath.NbtMappings> nbtMappings, List<LazyOptional<DataTransformer>> dataTransformers, Optional<AudioVisualEffect> effectOnMorph, CompoundTag defaultNbt) {
        this.morphMode = morphMode;
        this.entityToMorphTo = entityToMorphTo;
        this.nbtMappings = nbtMappings;
        this.dataTransformers = dataTransformers;
        this.effectOnMorph = effectOnMorph;
        this.defaultNbt = defaultNbt;
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        IMorphCapability morphCap;
        super.onUsedAbility(player, currentMorph);
        CompoundTag newTag = this.defaultNbt.m_6426_();
        if (currentMorph instanceof FallbackMorphItem) {
            FallbackMorphItem fallbackItem = (FallbackMorphItem)currentMorph;
            CompoundTag oldNbt = fallbackItem.serializeAdditional();
            this.nbtMappings.forEach(mapping -> mapping.copy(oldNbt, newTag));
            this.dataTransformers.forEach(dataTransformer -> ((DataTransformer)dataTransformer.resolve().get()).transformData(oldNbt, newTag));
        }
        FallbackMorphItem item = new FallbackMorphItem(newTag, this.entityToMorphTo);
        Optional<Integer> index = Optional.empty();
        if (!(this.morphMode != MorphMode.ADD_TO_LIST && this.morphMode != MorphMode.BOTH || (morphCap = MorphUtil.getCapOrNull(player)).getMorphList().contains(item))) {
            index = Optional.of(morphCap.addToMorphList(item));
            morphCap.syncMorphAcquisition(item);
        }
        if (this.morphMode == MorphMode.MORPH || this.morphMode == MorphMode.BOTH) {
            if (index.isPresent()) {
                MorphUtil.morphToServer(Optional.empty(), index, player);
            } else {
                MorphUtil.morphToServer(Optional.of(item), Optional.empty(), player);
            }
        }
        this.effectOnMorph.ifPresent(effect -> effect.playEffect((Entity)player));
    }

    public MorphMode getMorphMode() {
        return this.morphMode;
    }

    public EntityType<?> getEntityToMorphTo() {
        return this.entityToMorphTo;
    }

    public List<TransformEntityOnDeath.NbtMappings> getNbtMappings() {
        return this.nbtMappings;
    }

    public List<LazyOptional<DataTransformer>> getDataTransformers() {
        return this.dataTransformers;
    }

    public Optional<AudioVisualEffect> getEffectOnMorph() {
        return this.effectOnMorph;
    }

    public CompoundTag getDefaultNbt() {
        return this.defaultNbt;
    }

    public static enum MorphMode {
        ADD_TO_LIST,
        MORPH,
        BOTH;

    }
}

