/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.phantom_glide.ChargeDirection;
import de.budschie.bmorph.capabilities.phantom_glide.GlideCapabilityHandler;
import de.budschie.bmorph.capabilities.phantom_glide.GlideCapabilityInstance;
import de.budschie.bmorph.capabilities.phantom_glide.GlideStatus;
import de.budschie.bmorph.capabilities.phantom_glide.GlideStatusChangedEvent;
import de.budschie.bmorph.capabilities.phantom_glide.IGlideCapability;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PhantomAbility
extends Ability {
    public static final Codec<PhantomAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("charging_speed").forGetter(PhantomAbility::getChargingSpeed), (App)ModCodecs.VECTOR_3D.fieldOf("min_flight_speed").forGetter(PhantomAbility::getMinFlightSpeed), (App)ModCodecs.VECTOR_3D.fieldOf("max_flight_speed").forGetter(PhantomAbility::getMaxFlightSpeed), (App)Codec.INT.fieldOf("charging_ticks").forGetter(PhantomAbility::getMaxChargingTicks), (App)Codec.INT.fieldOf("transition_ticks").forGetter(PhantomAbility::getTransitionTicks), (App)ModCodecs.ABILITY.listOf().optionalFieldOf("gliding_abilities", Arrays.asList(new LazyOptional[0])).forGetter(PhantomAbility::getGlidingAbilities)).apply((Applicative)instance, PhantomAbility::new));
    private float chargingSpeed;
    private Vec3 minFlightSpeed;
    private Vec3 maxFlightSpeed;
    private int maxChargingTicks;
    private int transitionTicks;
    private List<LazyOptional<Ability>> glidingAbilities;

    public PhantomAbility(float chargingSpeed, Vec3 minFlightSpeed, Vec3 maxFlightSpeed, int maxChargingTicks, int transitionTicks, List<LazyOptional<Ability>> glidingAbilities) {
        this.chargingSpeed = chargingSpeed;
        this.minFlightSpeed = minFlightSpeed;
        this.maxFlightSpeed = maxFlightSpeed;
        this.maxChargingTicks = maxChargingTicks;
        this.transitionTicks = transitionTicks;
        this.glidingAbilities = glidingAbilities;
    }

    private void applyGlidingAbilities(Player player) {
        MorphUtil.processCap(player, cap -> {
            for (LazyOptional<Ability> ability : this.glidingAbilities) {
                ability.ifPresent(resolved -> cap.applyAbility((Ability)resolved));
            }
        });
    }

    private void deapplyGlidingAbilities(Player player) {
        MorphUtil.processCap(player, cap -> {
            for (LazyOptional<Ability> ability : this.glidingAbilities) {
                ability.ifPresent(resolved -> cap.deapplyAbility((Ability)resolved));
            }
        });
    }

    @Override
    public void enableAbility(Player player, MorphItem enabledItem, MorphItem oldMorph, List<Ability> oldAbilities, Ability.AbilityChangeReason reason) {
        super.enableAbility(player, enabledItem, oldMorph, oldAbilities, reason);
        player.getCapability(GlideCapabilityInstance.GLIDE_CAP).ifPresent(cap -> {
            if (cap.getGlideStatus() == GlideStatus.GLIDE) {
                this.applyGlidingAbilities(player);
            }
        });
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        player.getCapability(GlideCapabilityInstance.GLIDE_CAP).ifPresent(cap -> {
            if (cap.getGlideStatus() == GlideStatus.CHARGE) {
                GlideCapabilityHandler.INSTANCE.stopChargingServer(player);
            } else if (cap.getGlideStatus() == GlideStatus.GLIDE) {
                ChargeDirection dir = player.m_20155_().f_82470_ < 0.0f ? ChargeDirection.UP : ChargeDirection.DOWN;
                GlideCapabilityHandler.INSTANCE.startChargingServer(player, this.transitionTicks, this.maxChargingTicks, dir);
            } else if (cap.getGlideStatus() == GlideStatus.STANDARD && !this.cancelAbility(player)) {
                GlideCapabilityHandler.INSTANCE.glideServer(player);
            }
        });
    }

    @SubscribeEvent
    public void onGlideStatusChanged(GlideStatusChangedEvent event) {
        if (this.isTracked((Entity)event.getPlayer())) {
            if (event.getNewGlideStatus() == GlideStatus.GLIDE) {
                this.applyGlidingAbilities(event.getPlayer());
            } else if (event.getOldGlideStatus() == GlideStatus.GLIDE) {
                this.deapplyGlidingAbilities(event.getPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onUpdatePlayer(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.isTracked((Entity)event.player)) {
            event.player.getCapability(GlideCapabilityInstance.GLIDE_CAP).ifPresent(cap -> {
                if (cap.getGlideStatus() == GlideStatus.CHARGE) {
                    if (cap.getChargeDirection() != null) {
                        event.player.m_20256_(this.getChargeMovement((IGlideCapability)cap));
                    }
                    if (!event.player.f_19853_.m_5776_() && this.cancelAbility(event.player)) {
                        GlideCapabilityHandler.INSTANCE.standardServer(event.player);
                    }
                } else if (cap.getGlideStatus() == GlideStatus.GLIDE || cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_IN || cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_OUT) {
                    if (this.cancelAbility(event.player)) {
                        event.player.m_36321_();
                        if (!event.player.f_19853_.m_5776_()) {
                            GlideCapabilityHandler.INSTANCE.standardServer(event.player);
                        }
                    } else {
                        event.player.m_36320_();
                        Vec3 playerForward = event.player.m_20156_();
                        Vec3 playerMotion = event.player.m_20184_();
                        Vec3 newMovement = new Vec3(this.clamp(-this.maxFlightSpeed.f_82479_, this.maxFlightSpeed.f_82479_, this.minormax(playerForward.f_82479_ * this.minFlightSpeed.f_82479_, playerMotion.f_82479_)), this.clamp(-this.maxFlightSpeed.f_82480_, this.maxFlightSpeed.f_82480_, this.minormax(playerForward.f_82480_ * this.minFlightSpeed.f_82480_, playerMotion.f_82480_)), this.clamp(-this.maxFlightSpeed.f_82481_, this.maxFlightSpeed.f_82481_, this.minormax(playerForward.f_82481_ * this.minFlightSpeed.f_82481_, playerMotion.f_82481_)));
                        event.player.m_20256_(newMovement);
                    }
                }
                if (cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_IN || cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_OUT) {
                    boolean invert = cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_IN;
                    float progress = (float)Math.pow((float)cap.getTransitionTime() / (float)cap.getMaxTransitionTime(), 0.1f);
                    if (invert) {
                        progress = 1.0f - progress;
                    }
                    if (!Float.isFinite(progress)) {
                        progress = 0.0f;
                    }
                    event.player.m_20256_(event.player.m_20184_().m_165921_(this.getChargeMovement((IGlideCapability)cap), (double)progress));
                }
            });
        }
    }

    public double minormax(double a, double b) {
        if (Math.signum(a) < 0.0) {
            return Math.min(a, b);
        }
        return Math.max(a, b);
    }

    private double clamp(double smallestValue, double largestValue, double number) {
        if (number < smallestValue) {
            return smallestValue;
        }
        if (number > largestValue) {
            return largestValue;
        }
        return number;
    }

    private boolean cancelAbility(Player player) {
        return player.m_20096_() || player.m_20072_();
    }

    private Vec3 getChargeMovement(IGlideCapability cap) {
        return cap.getChargeDirection().getMovementDirection().m_82542_(1.0, (double)this.chargingSpeed, 1.0);
    }

    public List<LazyOptional<Ability>> getGlidingAbilities() {
        return this.glidingAbilities;
    }

    public float getChargingSpeed() {
        return this.chargingSpeed;
    }

    public Vec3 getMinFlightSpeed() {
        return this.minFlightSpeed;
    }

    public Vec3 getMaxFlightSpeed() {
        return this.maxFlightSpeed;
    }

    public int getMaxChargingTicks() {
        return this.maxChargingTicks;
    }

    public int getTransitionTicks() {
        return this.transitionTicks;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

