/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.AbilitySerializationContext;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.LazyRegistryWrapper;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.StunAbility;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import de.budschie.bmorph.util.BudschieUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PredicateAbility
extends StunAbility {
    public static final Codec<PredicateAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("stun").forGetter(StunAbility::getStun), (App)ModCodecs.PREDICATE.listOf().listOf().fieldOf("predicates").forGetter(PredicateAbility::getPredicates), (App)Codec.BOOL.fieldOf("execute_once").forGetter(PredicateAbility::shouldExecuteOnce), (App)Codec.INT.fieldOf("predicate_true_for_time").forGetter(PredicateAbility::getPredicateTrueForTime), (App)ModCodecs.ABILITY.fieldOf("ability_to_execute").forGetter(PredicateAbility::getAbilityToExecuteOnSuccess)).apply((Applicative)instance, PredicateAbility::new));
    private List<List<LazyRegistryWrapper<LootItemCondition>>> predicates;
    private boolean executeOnce;
    private int predicateTrueForTime;
    private LazyOptional<Ability> abilityToExecuteOnSuccess;
    private HashMap<UUID, Integer> players = new HashMap();
    private HashSet<UUID> alreadyReceivedAbility = new HashSet();

    public PredicateAbility(int stun, List<List<LazyRegistryWrapper<LootItemCondition>>> predicates, boolean executeOnce, int predicateTrueForTime, LazyOptional<Ability> abilityToExecuteOnSuccess) {
        super(stun);
        this.predicates = predicates;
        this.executeOnce = executeOnce;
        this.predicateTrueForTime = predicateTrueForTime;
        this.abilityToExecuteOnSuccess = abilityToExecuteOnSuccess;
    }

    @SubscribeEvent
    public void onPlayersUpdated(TickEvent.ServerTickEvent event) {
        UUID[] trackedPlayersClone;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        LootItemCondition[][] lootItemConditions = BudschieUtils.resolveConditions(this.predicates);
        for (UUID uuid : trackedPlayersClone = (UUID[])this.trackedPlayers.toArray(UUID[]::new)) {
            if (this.alreadyReceivedAbility.contains(uuid) || this.isCurrentlyStunned(uuid)) continue;
            ServerPlayer currentPlayer = ServerSetup.server.m_6846_().m_11259_(uuid);
            LootContext.Builder predicateContext = new LootContext.Builder((ServerLevel)currentPlayer.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)currentPlayer.m_20182_()).m_78984_(LootContextParams.f_81455_, (Object)currentPlayer);
            boolean predicateTrue = BudschieUtils.testPredicates(lootItemConditions, () -> predicateContext.m_78975_(LootContextParamSets.f_81412_));
            if (predicateTrue) {
                if (this.players.containsKey(currentPlayer.m_142081_())) {
                    if (!this.hasPassedTimestamp((Player)currentPlayer)) continue;
                    this.removePlayerFromTimestamp((Player)currentPlayer);
                    if (this.executeOnce) {
                        this.alreadyReceivedAbility.add(uuid);
                    }
                    ((Ability)this.abilityToExecuteOnSuccess.resolve().get()).onUsedAbility((Player)currentPlayer, MorphUtil.getCapOrNull((Player)currentPlayer).getCurrentMorph().get());
                    this.stun(uuid);
                    continue;
                }
                this.addTimestampForPlayer((Player)currentPlayer, this.predicateTrueForTime);
                continue;
            }
            if (!this.players.containsKey(currentPlayer.m_142081_())) continue;
            this.removePlayerFromTimestamp((Player)currentPlayer);
        }
    }

    @Override
    public void serialize(Player player, AbilitySerializationContext context, boolean canSaveTransientData) {
        super.serialize(player, context, canSaveTransientData);
        if (!canSaveTransientData) {
            return;
        }
        CompoundTag tag = context.getOrCreateSerializationObjectForAbility(this).getOrCreateTransientTag();
        if (this.players.containsKey(player.m_142081_())) {
            tag.m_128405_("predicate_ability_time_until_ability", this.getTimeLeftForPlayerToReceiveAbility(player));
        }
        if (this.alreadyReceivedAbility.contains(player.m_142081_())) {
            tag.m_128379_("predicate_ability_already_received", true);
        }
    }

    @Override
    public void deserialize(Player player, AbilitySerializationContext context) {
        super.deserialize(player, context);
        context.getSerializationObjectForAbility(this).ifPresent(obj -> obj.getTransientTag().ifPresent(tag -> {
            if (tag.m_128441_("predicate_ability_time_until_ability")) {
                this.addTimestampForPlayer(player, tag.m_128451_("predicate_ability_time_until_ability"));
            }
            if (tag.m_128441_("predicate_ability_already_received") && this.executeOnce) {
                this.alreadyReceivedAbility.add(player.m_142081_());
            }
        }));
    }

    public int getTimeLeftForPlayerToReceiveAbility(Player player) {
        return this.players.get(player.m_142081_()) - ServerSetup.server.m_129921_();
    }

    public void removePlayerFromTimestamp(Player player) {
        this.players.remove(player.m_142081_());
    }

    public void addTimestampForPlayer(Player player, int time) {
        this.players.put(player.m_142081_(), time + ServerSetup.server.m_129921_());
    }

    public boolean hasPassedTimestamp(Player player) {
        return this.players.containsKey(player.m_142081_()) && ServerSetup.server.m_129921_() > this.players.get(player.m_142081_());
    }

    @Override
    public void removePlayerReferences(Player playerRefToRemove) {
        super.removePlayerReferences(playerRefToRemove);
        this.players.remove(playerRefToRemove.m_142081_());
        this.alreadyReceivedAbility.remove(playerRefToRemove.m_142081_());
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }

    public List<List<LazyRegistryWrapper<LootItemCondition>>> getPredicates() {
        return this.predicates;
    }

    public boolean shouldExecuteOnce() {
        return this.executeOnce;
    }

    public int getPredicateTrueForTime() {
        return this.predicateTrueForTime;
    }

    public LazyOptional<Ability> getAbilityToExecuteOnSuccess() {
        return this.abilityToExecuteOnSuccess;
    }

    public HashMap<UUID, Integer> getPlayers() {
        return this.players;
    }

    public HashSet<UUID> getAlreadyReceivedAbility() {
        return this.alreadyReceivedAbility;
    }
}

