/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.StunAbility;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ProjectileShootingAbility
extends StunAbility {
    public static final Codec<ProjectileShootingAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.ENTITIES.fieldOf("projectile_entity").forGetter(ProjectileShootingAbility::getProjectileEntityType), (App)Codec.INT.optionalFieldOf("stun", (Object)0).forGetter(StunAbility::getStun), (App)Codec.DOUBLE.optionalFieldOf("motion", (Object)0.0).forGetter(ProjectileShootingAbility::getMotion), (App)CompoundTag.f_128325_.optionalFieldOf("nbt", (Object)new CompoundTag()).forGetter(ProjectileShootingAbility::getNbtData), (App)AudioVisualEffect.CODEC.optionalFieldOf("audiovisual_effect").forGetter(ProjectileShootingAbility::getAudioVisualEffect)).apply((Applicative)instance, ProjectileShootingAbility::new));
    private EntityType<?> projectileEntityType;
    private double motion;
    private CompoundTag nbtData;
    private Optional<AudioVisualEffect> audioVisualEffect;

    public ProjectileShootingAbility(EntityType<?> projectileEntityType, int stun, double motion, CompoundTag nbtData, Optional<AudioVisualEffect> audioVisualEffect) {
        super(stun);
        this.motion = motion;
        this.projectileEntityType = projectileEntityType;
        this.nbtData = nbtData;
        this.audioVisualEffect = audioVisualEffect;
    }

    public EntityType<?> getProjectileEntityType() {
        return this.projectileEntityType;
    }

    public double getMotion() {
        return this.motion;
    }

    public CompoundTag getNbtData() {
        return this.nbtData;
    }

    public Optional<AudioVisualEffect> getAudioVisualEffect() {
        return this.audioVisualEffect;
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (!this.isCurrentlyStunned(player.m_142081_())) {
            Entity createdEntity = this.projectileEntityType.m_20615_(player.f_19853_);
            createdEntity.m_20258_(this.nbtData);
            Vec3 dir = Vec3.m_82503_((Vec2)player.m_20155_()).m_82541_();
            createdEntity.m_20334_(dir.f_82479_ * this.motion, dir.f_82480_ * this.motion, dir.f_82481_ * this.motion);
            createdEntity.m_7678_(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_(), player.m_6080_(), player.m_146909_());
            if (createdEntity instanceof Projectile) {
                Projectile proj = (Projectile)createdEntity;
                proj.m_5602_((Entity)player);
            }
            if (createdEntity instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile dmgProjectile = (AbstractHurtingProjectile)createdEntity;
                dmgProjectile.f_36813_ = dir.f_82479_ * 0.1;
                dmgProjectile.f_36814_ = dir.f_82480_ * 0.1;
                dmgProjectile.f_36815_ = dir.f_82481_ * 0.1;
            }
            player.f_19853_.m_7967_(createdEntity);
            this.stun(player.m_142081_());
            this.audioVisualEffect.ifPresent(ave -> ave.playEffect((Entity)player));
        }
    }
}

