/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.pufferfish.IPufferfishCapability;
import de.budschie.bmorph.capabilities.pufferfish.PufferfishCapabilityHandler;
import de.budschie.bmorph.capabilities.pufferfish.PufferfishCapabilityInstance;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.StunAbility;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import de.budschie.bmorph.util.SoundInstance;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PufferfishAbility
extends StunAbility {
    public static final Codec<PufferfishAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("stun").forGetter(StunAbility::getStun), (App)Codec.list(ModCodecs.EFFECT_INSTANCE).fieldOf("effects_on_use").forGetter(PufferfishAbility::getEffects), (App)Codec.FLOAT.fieldOf("direct_damage").forGetter(PufferfishAbility::getDirectDamage), (App)Codec.FLOAT.fieldOf("ability_radius").forGetter(PufferfishAbility::getRadius), (App)Codec.INT.fieldOf("duration").forGetter(PufferfishAbility::getDuration), (App)SoundInstance.CODEC.optionalFieldOf("sting_sound", (Object)new SoundInstance(SoundEvents.f_12295_, SoundSource.HOSTILE, 1.0f, 0.125f, 1.0f)).forGetter(PufferfishAbility::getStingSoundEffect), (App)SoundInstance.CODEC.optionalFieldOf("fish_blow_up", (Object)new SoundInstance(SoundEvents.f_12291_, SoundSource.HOSTILE, 1.0f, 0.125f, 1.0f)).forGetter(PufferfishAbility::getBlowUpSoundEffect), (App)SoundInstance.CODEC.optionalFieldOf("fish_blow_out", (Object)new SoundInstance(SoundEvents.f_12290_, SoundSource.HOSTILE, 1.0f, 0.125f, 1.0f)).forGetter(PufferfishAbility::getBlowOutSoundEffect)).apply((Applicative)instance, PufferfishAbility::new));
    private List<MobEffectInstance> effects;
    private float directDamage;
    private float radius;
    private int duration;
    private SoundInstance stingSoundEffect;
    private SoundInstance blowUpSoundEffect;
    private SoundInstance blowOutSoundEffect;

    public PufferfishAbility(int stun, List<MobEffectInstance> effects, float directDamage, float radius, int duration, SoundInstance stingSoundEffect, SoundInstance blowUpSoundEffect, SoundInstance blowOutSoundEffect) {
        super(stun);
        this.effects = effects;
        this.directDamage = directDamage;
        this.radius = radius;
        this.duration = duration;
        this.stingSoundEffect = stingSoundEffect;
        this.blowUpSoundEffect = blowUpSoundEffect;
        this.blowOutSoundEffect = blowOutSoundEffect;
    }

    public SoundInstance getStingSoundEffect() {
        return this.stingSoundEffect;
    }

    public SoundInstance getBlowUpSoundEffect() {
        return this.blowUpSoundEffect;
    }

    public SoundInstance getBlowOutSoundEffect() {
        return this.blowOutSoundEffect;
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public float getDirectDamage() {
        return this.directDamage;
    }

    public float getRadius() {
        return this.radius;
    }

    public int getDuration() {
        return this.duration;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (UUID playerId : this.trackedPlayers) {
                ServerPlayer player = ServerSetup.server.m_6846_().m_11259_(playerId);
                if (!this.trackedPlayers.contains(player.m_142081_())) continue;
                player.getCapability(PufferfishCapabilityInstance.PUFFER_CAP).ifPresent(arg_0 -> this.lambda$onPlayerTick$1((Player)player, arg_0));
            }
        }
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (!this.isCurrentlyStunned(player.m_142081_())) {
            this.stun(player.m_142081_());
            PufferfishCapabilityHandler.INSTANCE.puffServer(player, this.duration);
            this.blowUpSoundEffect.playSoundAt((Entity)player);
        }
    }

    @Override
    public void disableAbility(Player player, MorphItem disabledItem, MorphItem newMorph, List<Ability> newAbilities, Ability.AbilityChangeReason reason) {
        super.disableAbility(player, disabledItem, newMorph, newAbilities, reason);
        player.getCapability(PufferfishCapabilityInstance.PUFFER_CAP).ifPresent(cap -> cap.puff(0));
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }

    private /* synthetic */ void lambda$onPlayerTick$1(Player player, IPufferfishCapability cap) {
        if (cap.getPuffTime() > 0) {
            List entities = player.m_20193_().m_45976_(LivingEntity.class, player.m_142469_().m_82400_((double)this.radius));
            for (LivingEntity entity : entities) {
                if (entity == player || !entity.m_6084_() || !entity.m_6469_(DamageSource.m_19370_((LivingEntity)player), this.directDamage)) continue;
                for (MobEffectInstance effect : this.effects) {
                    entity.m_7292_(new MobEffectInstance(effect));
                }
                this.stingSoundEffect.playSoundAt((Entity)entity);
            }
            if (cap.getPuffTime() == 5) {
                this.blowOutSoundEffect.playSoundAt((Entity)player);
            }
        }
    }
}

