/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.StunAbility;
import de.budschie.bmorph.util.WeightedList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RandomDelegatingOnUseAbility
extends StunAbility {
    private static Logger LOGGER = LogManager.getLogger();
    public static final Codec<RandomDelegatingOnUseAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("stun").forGetter(StunAbility::getStun), (App)WeightedList.codecOf(ResourceLocation.f_135803_).fieldOf("abilities").forGetter(RandomDelegatingOnUseAbility::getWeightedList)).apply((Applicative)instance, RandomDelegatingOnUseAbility::new));
    private WeightedList<ResourceLocation> weightedList;

    public RandomDelegatingOnUseAbility(int stun, WeightedList<ResourceLocation> weightedList) {
        super(stun);
        this.weightedList = weightedList;
    }

    public WeightedList<ResourceLocation> getWeightedList() {
        return this.weightedList;
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (!this.isCurrentlyStunned(player.m_142081_())) {
            this.stun(player.m_142081_());
            ResourceLocation randomRL = this.weightedList.getRandom(player.m_20193_().m_5822_());
            Ability ability = (Ability)BMorphMod.DYNAMIC_ABILITY_REGISTRY.getEntry(randomRL);
            if (ability == null) {
                LOGGER.warn(String.format("The random delegating ability %s tried to delegate its work to %s, but that ability doesn't exist.", this.getResourceLocation(), randomRL));
            } else {
                ability.onUsedAbility(player, currentMorph);
            }
        }
    }
}

