/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.sheep.SheepCapabilityHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.StunAbility;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SheepEatGrassAbility
extends StunAbility {
    public static final Codec<SheepEatGrassAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AudioVisualEffect.CODEC.optionalFieldOf("shear_effect").forGetter(SheepEatGrassAbility::getShearEffect), (App)AudioVisualEffect.CODEC.optionalFieldOf("consume_grass_effect").forGetter(SheepEatGrassAbility::getConsumeGrassEffect), (App)AudioVisualEffect.CODEC.optionalFieldOf("saturated_effect").forGetter(SheepEatGrassAbility::getSaturatedFeedback), (App)ModCodecs.DIRECTION_ENUM.listOf().fieldOf("valid_directions").forGetter(SheepEatGrassAbility::getValidEatingDirections), (App)ModCodecs.BLOCKS.fieldOf("valid_eatable_block").forGetter(SheepEatGrassAbility::getFromBlock), (App)BlockStateProvider.f_68747_.fieldOf("transform_to_block").forGetter(SheepEatGrassAbility::getToBlock), (App)Codec.INT.fieldOf("stun").forGetter(StunAbility::getStun), (App)Codec.INT.fieldOf("gain_food_level").forGetter(SheepEatGrassAbility::getGainFoodLevel), (App)Codec.FLOAT.fieldOf("gain_saturation").forGetter(SheepEatGrassAbility::getGainSaturation)).apply((Applicative)instance, SheepEatGrassAbility::new));
    private Optional<AudioVisualEffect> shearEffect;
    private Optional<AudioVisualEffect> consumeGrassEffect;
    private Optional<AudioVisualEffect> saturatedFeedback;
    private List<Direction> validEatingDirections;
    private Block fromBlock;
    private BlockStateProvider toBlock;
    private int gainFoodLevel;
    private float gainSaturation;

    public SheepEatGrassAbility(Optional<AudioVisualEffect> shearEffect, Optional<AudioVisualEffect> consumeGrassEffect, Optional<AudioVisualEffect> saturatedFeedback, List<Direction> validEatingDirections, Block fromBlock, BlockStateProvider toBlock, int stun, int gainFoodLevel, float gainSaturation) {
        super(stun);
        this.shearEffect = shearEffect;
        this.consumeGrassEffect = consumeGrassEffect;
        this.saturatedFeedback = saturatedFeedback;
        this.validEatingDirections = validEatingDirections;
        this.fromBlock = fromBlock;
        this.toBlock = toBlock;
        this.gainFoodLevel = gainFoodLevel;
        this.gainSaturation = gainSaturation;
    }

    @SubscribeEvent
    public void onShearedPlayer(PlayerInteractEvent.EntityInteract event) {
        if (event.getItemStack().m_41720_() instanceof ShearsItem && event.getTarget() instanceof Player && this.isTracked(event.getTarget()) && !SheepCapabilityHandler.INSTANCE.isSheared((Player)event.getTarget())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            if (!event.getWorld().m_5776_()) {
                Player target = (Player)event.getTarget();
                this.shear(target);
                event.getItemStack().m_41622_(1, (LivingEntity)event.getPlayer(), player -> player.m_21190_(event.getHand()));
            }
        }
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (player.m_6047_() && !SheepCapabilityHandler.INSTANCE.isSheared(player)) {
            this.shear(player);
        } else if (!this.isCurrentlyStunned(player.m_142081_())) {
            if (player.m_36324_().m_38721_()) {
                Vec3 to;
                Vec3 from = player.m_20182_().m_82549_(Vec3.m_82503_((Vec2)player.m_20155_())).m_82520_(0.0, (double)player.m_20192_(), 0.0);
                ClipContext context = new ClipContext(from, to = Vec3.m_82503_((Vec2)player.m_20155_()).m_82542_(4.0, 4.0, 4.0).m_82549_(from), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null);
                BlockHitResult result = player.f_19853_.m_45547_(context);
                if (result != null && result.m_6662_() == HitResult.Type.BLOCK && this.validEatingDirections.contains(result.m_82434_()) && player.f_19853_.m_8055_(result.m_82425_()).m_60734_() == this.fromBlock) {
                    SheepCapabilityHandler.INSTANCE.setSheared(player, false);
                    this.consumeGrassEffect.ifPresent(ave -> ave.playEffect((Entity)player));
                    player.f_19853_.m_46597_(result.m_82425_(), this.toBlock.m_7112_(player.m_183503_().m_5822_(), result.m_82425_()));
                    player.m_36324_().m_38707_(this.gainFoodLevel, this.gainSaturation);
                    this.stun(player.m_142081_());
                }
            } else {
                this.saturatedFeedback.ifPresent(ave -> ave.playEffect((Entity)player));
            }
        }
    }

    private void shear(Player playerToBeSheared) {
        DyeColor currentDyeColor = DyeColor.WHITE;
        this.shearEffect.ifPresent(ave -> ave.playEffect((Entity)playerToBeSheared));
        IMorphCapability morphCap = MorphUtil.getCapOrNull(playerToBeSheared);
        if (morphCap != null && morphCap.getCurrentMorph().isPresent()) {
            currentDyeColor = DyeColor.m_41053_((int)morphCap.getCurrentMorph().get().serializeAdditional().m_128445_("Color"));
        }
        int i = 1 + playerToBeSheared.m_21187_().nextInt(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = playerToBeSheared.m_20000_((ItemLike)Sheep.f_29800_.get(currentDyeColor), 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)(playerToBeSheared.m_21187_().nextFloat() - playerToBeSheared.m_21187_().nextFloat()) * 0.1, playerToBeSheared.m_21187_().nextDouble() * 0.05, (playerToBeSheared.m_21187_().nextDouble() - playerToBeSheared.m_21187_().nextDouble()) * 0.1));
        }
        SheepCapabilityHandler.INSTANCE.setSheared(playerToBeSheared, true);
    }

    public Optional<AudioVisualEffect> getConsumeGrassEffect() {
        return this.consumeGrassEffect;
    }

    public Optional<AudioVisualEffect> getSaturatedFeedback() {
        return this.saturatedFeedback;
    }

    public Optional<AudioVisualEffect> getShearEffect() {
        return this.shearEffect;
    }

    public List<Direction> getValidEatingDirections() {
        return this.validEatingDirections;
    }

    public Block getFromBlock() {
        return this.fromBlock;
    }

    public BlockStateProvider getToBlock() {
        return this.toBlock;
    }

    public int getGainFoodLevel() {
        return this.gainFoodLevel;
    }

    public float getGainSaturation() {
        return this.gainSaturation;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }
}

