/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.functionality.StunAbility;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.network.SquidBoost;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class SquidBoostAbility
extends StunAbility {
    public static final Codec<SquidBoostAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.EFFECT_INSTANCE.listOf().fieldOf("effects").forGetter(SquidBoostAbility::getEffects), (App)Codec.INT.optionalFieldOf("effect_radius", (Object)5).forGetter(SquidBoostAbility::getBlindnessRadius), (App)Codec.FLOAT.fieldOf("boost_amount").forGetter(SquidBoostAbility::getBoostAmount), (App)Codec.INT.fieldOf("stun").forGetter(StunAbility::getStun), (App)AudioVisualEffect.CODEC.optionalFieldOf("audiovisual_effect", (Object)new AudioVisualEffect()).forGetter(SquidBoostAbility::getAudioVisualEffect)).apply((Applicative)instance, SquidBoostAbility::new));
    private float boostAmount;
    private int effectRadius;
    private List<MobEffectInstance> effects;
    private AudioVisualEffect audioVisualEffect;

    public SquidBoostAbility(List<MobEffectInstance> effects, int blindnessRadius, float boostAmount, int stun, AudioVisualEffect particleClouds) {
        super(stun);
        this.effects = effects;
        this.effectRadius = blindnessRadius;
        this.boostAmount = boostAmount;
        this.audioVisualEffect = particleClouds;
    }

    public int getBlindnessRadius() {
        return this.effectRadius;
    }

    public List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    public float getBoostAmount() {
        return this.boostAmount;
    }

    public AudioVisualEffect getAudioVisualEffect() {
        return this.audioVisualEffect;
    }

    @Override
    public void onUsedAbility(Player player, MorphItem currentMorph) {
        if (!this.isCurrentlyStunned(player.m_142081_())) {
            if (!player.f_19853_.m_5776_()) {
                this.audioVisualEffect.playEffect((Entity)player);
            }
            player.f_19853_.m_45933_((Entity)player, new AABB(player.m_142538_().m_142082_(-this.effectRadius, -this.effectRadius, -this.effectRadius), player.m_142538_().m_142082_(this.effectRadius, this.effectRadius, this.effectRadius))).forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    this.effects.forEach(effect -> ((LivingEntity)entity).m_7292_(new MobEffectInstance(effect)));
                }
            });
            this.stun(player.m_142081_());
            MainNetworkChannel.INSTANCE.send(PacketDistributor.DIMENSION.with(() -> player.f_19853_.m_46472_()), (Object)new SquidBoost.SquidBoostPacket(this.boostAmount, player.m_142081_()));
        }
    }
}

