/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TeleportOnProjectileContactAbility
extends Ability {
    public static final Codec<TeleportOnProjectileContactAbility> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("max_tries", (Object)64).forGetter(TeleportOnProjectileContactAbility::getMaxTries), (App)ModCodecs.VECTOR_3D_I.optionalFieldOf("search_radius", (Object)new Vec3i(32, 32, 32)).forGetter(TeleportOnProjectileContactAbility::getSearchRadius), (App)AudioVisualEffect.CODEC.optionalFieldOf("teleportation_effect").forGetter(TeleportOnProjectileContactAbility::getTeleportationEffect)).apply((Applicative)instance, TeleportOnProjectileContactAbility::new));
    private int maxTries;
    private Vec3i searchRadius;
    private Optional<AudioVisualEffect> teleportationEffect;

    public TeleportOnProjectileContactAbility(int maxTries, Vec3i searchRadius, Optional<AudioVisualEffect> teleportationEffect) {
        this.maxTries = maxTries;
        this.searchRadius = searchRadius;
        this.teleportationEffect = teleportationEffect;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }

    @SubscribeEvent
    public void onLivingEntityDamaged(LivingAttackEvent event) {
        if (!this.isTracked(event.getEntity())) {
            return;
        }
        if (event.getEntity().f_19853_.m_5776_()) {
            return;
        }
        if (event.getSource().m_19360_()) {
            event.setCanceled(true);
            BlockPos foundBlock = null;
            for (int i = 0; i < this.maxTries; ++i) {
                BlockState blockAtPos;
                int z;
                int y;
                int x = (int)((double)(event.getEntityLiving().m_21187_().nextInt(this.searchRadius.m_123341_() * 2) - this.searchRadius.m_123341_()) + event.getEntity().m_20185_());
                foundBlock = new BlockPos(x, y = (int)((double)(event.getEntityLiving().m_21187_().nextInt(this.searchRadius.m_123342_() * 2) - this.searchRadius.m_123342_()) + event.getEntity().m_20186_()), z = (int)((double)(event.getEntityLiving().m_21187_().nextInt(this.searchRadius.m_123343_() * 2) - this.searchRadius.m_123343_()) + event.getEntity().m_20189_()));
                if (!event.getEntity().f_19853_.m_46749_(foundBlock) || (blockAtPos = event.getEntity().f_19853_.m_8055_(foundBlock)).m_60767_().m_76334_() || blockAtPos.m_60819_().m_205070_(FluidTags.f_13131_) || !event.getEntityLiving().m_20984_((double)x, (double)y, (double)z, false)) continue;
                this.teleportationEffect.ifPresent(ave -> ave.playEffect(event.getEntity()));
                break;
            }
        }
    }

    public int getMaxTries() {
        return this.maxTries;
    }

    public Vec3i getSearchRadius() {
        return this.searchRadius;
    }

    public Optional<AudioVisualEffect> getTeleportationEffect() {
        return this.teleportationEffect;
    }
}

