/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.configurable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.json_integration.NBTPath;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.codec_addition.AudioVisualEffect;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import de.budschie.bmorph.util.EntityUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TransformEntityOnDeath
extends Ability {
    public static Codec<TransformEntityOnDeath> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.ENTITIES.fieldOf("transform_from").forGetter(TransformEntityOnDeath::getEntityToTransformFrom), (App)ModCodecs.ENTITIES.fieldOf("transform_to").forGetter(TransformEntityOnDeath::getEntityToTransformTo), (App)NbtMappings.CODEC.listOf().optionalFieldOf("nbt_mappings", Arrays.asList(new NbtMappings[0])).forGetter(TransformEntityOnDeath::getNbtMappings), (App)ModCodecs.DATA_TRANSFORMER.listOf().optionalFieldOf("data_transformers", Arrays.asList(new LazyOptional[0])).forGetter(TransformEntityOnDeath::getDataTransformers), (App)Codec.STRING.listOf().optionalFieldOf("permitted_deaths").forGetter(TransformEntityOnDeath::getPermittedDeaths), (App)AudioVisualEffect.CODEC.optionalFieldOf("transformed_entity_effect").forGetter(TransformEntityOnDeath::getTransformedEntityEffect), (App)AudioVisualEffect.CODEC.optionalFieldOf("transformer_entity_effect").forGetter(TransformEntityOnDeath::getTransformerEntityEffect)).apply((Applicative)instance, TransformEntityOnDeath::new));
    private EntityType<?> entityToTransformFrom;
    private EntityType<?> entityToTransformTo;
    private List<NbtMappings> nbtMappings;
    private List<LazyOptional<DataTransformer>> dataTransformers;
    private Optional<List<String>> permittedDeaths;
    private Optional<AudioVisualEffect> transformedAudioVisualEffect;
    private Optional<AudioVisualEffect> transformerAudioVisualEffect;

    public TransformEntityOnDeath(EntityType<?> entityToTransformFrom, EntityType<?> entityToTransformTo, List<NbtMappings> nbtMappings, List<LazyOptional<DataTransformer>> dataTransformers, Optional<List<String>> permittedDeaths, Optional<AudioVisualEffect> transformedAudioVisualEffect, Optional<AudioVisualEffect> transformerAudioVisualEffect) {
        this.entityToTransformFrom = entityToTransformFrom;
        this.entityToTransformTo = entityToTransformTo;
        this.nbtMappings = nbtMappings;
        this.dataTransformers = dataTransformers;
        this.permittedDeaths = permittedDeaths;
        this.transformedAudioVisualEffect = transformedAudioVisualEffect;
        this.transformerAudioVisualEffect = transformerAudioVisualEffect;
    }

    @SubscribeEvent
    public void onLivingEntityKilled(LivingDeathEvent event) {
        if (event.getEntity().m_6095_() == this.entityToTransformFrom && event.getSource() != null && event.getSource().m_7639_() != null && this.isTracked(event.getSource().m_7639_()) && (this.permittedDeaths.isEmpty() || this.permittedDeaths.get().contains(event.getSource().m_19385_()))) {
            Entity newEntity = this.entityToTransformTo.m_20615_(event.getEntity().f_19853_);
            EntityUtil.copyLocationAndRotation(event.getEntity(), newEntity);
            CompoundTag tagOld = new CompoundTag();
            CompoundTag tagNew = new CompoundTag();
            EntityUtil.addAdditionalSaveData(event.getEntity(), tagOld);
            this.nbtMappings.forEach(mapping -> mapping.copy(tagOld, tagNew));
            this.dataTransformers.forEach(dataTransformer -> ((DataTransformer)dataTransformer.resolve().get()).transformData(tagOld, tagNew));
            EntityUtil.readAdditionalSaveData(newEntity, tagNew);
            event.getEntity().f_19853_.m_7967_(newEntity);
            event.getEntity().m_146870_();
            if (!event.getEntity().f_19853_.m_5776_()) {
                this.transformedAudioVisualEffect.ifPresent(effect -> effect.playEffect(newEntity));
                this.transformerAudioVisualEffect.ifPresent(effect -> effect.playEffect(event.getSource().m_7639_()));
            }
        }
    }

    public EntityType<?> getEntityToTransformFrom() {
        return this.entityToTransformFrom;
    }

    public EntityType<?> getEntityToTransformTo() {
        return this.entityToTransformTo;
    }

    public List<NbtMappings> getNbtMappings() {
        return this.nbtMappings;
    }

    public List<LazyOptional<DataTransformer>> getDataTransformers() {
        return this.dataTransformers;
    }

    public Optional<List<String>> getPermittedDeaths() {
        return this.permittedDeaths;
    }

    public Optional<AudioVisualEffect> getTransformedEntityEffect() {
        return this.transformedAudioVisualEffect;
    }

    public Optional<AudioVisualEffect> getTransformerEntityEffect() {
        return this.transformerAudioVisualEffect;
    }

    @Override
    public boolean isAbleToReceiveEvents() {
        return true;
    }

    public static class NbtMappings {
        public static final Codec<NbtMappings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NBTPath.CODEC.fieldOf("copy_nbt_source").forGetter(NbtMappings::getSourcePath), (App)NBTPath.CODEC.fieldOf("copy_nbt_dest").forGetter(NbtMappings::getDestinationPath)).apply((Applicative)instance, NbtMappings::new));
        private NBTPath src;
        private NBTPath dest;

        public NbtMappings(NBTPath src, NBTPath dest) {
            this.src = src;
            this.dest = dest;
        }

        public NBTPath getSourcePath() {
            return this.src;
        }

        public NBTPath getDestinationPath() {
            return this.dest;
        }

        public void copy(CompoundTag from, CompoundTag to) {
            this.src.copyTo(from, to, this.dest);
        }
    }
}

