/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.data_transformers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.functionality.data_transformers.DataModifier;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.LazyOptional;

public class ConditionalModifier
extends DataModifier {
    private static final Codec<OperatorType> OPERATOR_CODEC = Codec.STRING.flatXmap(convertToOp -> {
        OperatorType type = OperatorType.getOperatorByName(convertToOp);
        if (type == null) {
            return DataResult.error((String)String.format("Unknown operator type \"%s\" in your conditional_modifier.", new Object[0]));
        }
        return DataResult.success((Object)((Object)type));
    }, opType -> DataResult.success((Object)opType.getOperatorName()));
    private static final Codec<DataType> DATA_TYPE_CODEC = Codec.STRING.flatXmap(convertToOp -> {
        DataType type = DataType.getDataTypeByName(convertToOp);
        if (type == null) {
            return DataResult.error((String)String.format("Unknown data type \"%s\" in your conditional_modifier.", new Object[0]));
        }
        return DataResult.success((Object)((Object)type));
    }, opType -> DataResult.success((Object)opType.getDataTypeName()));
    public static final Codec<ConditionalModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OPERATOR_CODEC.fieldOf("operator").forGetter(ConditionalModifier::getOperatorType), (App)Codec.DOUBLE.fieldOf("to_compare").forGetter(ConditionalModifier::getToCompare), (App)Codec.DOUBLE.fieldOf("then").forGetter(ConditionalModifier::getThen), (App)Codec.mapEither((MapCodec)Codec.of((Encoder)new Encoder<ConditionalModifier>(){

        public <T> DataResult<T> encode(ConditionalModifier input, DynamicOps<T> ops, T prefix) {
            return CODEC.encodeStart(ops, (Object)input);
        }
    }, (Decoder)new Decoder<ConditionalModifier>(){

        public <T> DataResult<Pair<ConditionalModifier, T>> decode(DynamicOps<T> ops, T input) {
            return CODEC.decode(ops, input);
        }
    }).fieldOf("else_if"), (MapCodec)Codec.DOUBLE.fieldOf("else")).forGetter(ConditionalModifier::getElifTerm), (App)DATA_TYPE_CODEC.optionalFieldOf("data_type").forGetter(ConditionalModifier::getDataTypeOutput)).apply((Applicative)instance, ConditionalModifier::new));
    private OperatorType operatorType;
    private Either<ConditionalModifier, Double> elifTerm;
    private double toCompare;
    private double then;
    private Optional<DataType> dataTypeOutput;

    public ConditionalModifier(OperatorType operatorType, double toCompare, double then, Either<ConditionalModifier, Double> elifTerm, Optional<DataType> dataTypeOutput) {
        this.operatorType = operatorType;
        this.elifTerm = elifTerm;
        this.toCompare = toCompare;
        this.then = then;
        this.dataTypeOutput = dataTypeOutput;
    }

    @Override
    public boolean canOperateOn(Optional<Tag> nbtTag) {
        return nbtTag.isPresent() && nbtTag.get() instanceof NumericTag;
    }

    @Override
    public Optional<Tag> applyModifier(Optional<Tag> inputTag) {
        boolean success = this.operatorType.applyOperation(inputTag.get(), this.toCompare);
        if (success) {
            return Optional.of(ConditionalModifier.convertToTag(inputTag.get().m_7060_(), this.then));
        }
        if (this.elifTerm.right().isPresent()) {
            ConditionalModifier.convertToTag(inputTag.get().m_7060_(), (Double)this.elifTerm.right().get());
        } else if (this.elifTerm.left().isPresent()) {
            if (((ConditionalModifier)this.elifTerm.left().get()).canOperateOn(inputTag)) {
                return ((ConditionalModifier)this.elifTerm.left().get()).applyModifier(inputTag);
            }
            throw new IllegalArgumentException(String.format("The provided tag type for the ConditionalModifier is illegal.", new Object[0]));
        }
        return inputTag;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public Either<ConditionalModifier, Double> getElifTerm() {
        return this.elifTerm;
    }

    public double getToCompare() {
        return this.toCompare;
    }

    public double getThen() {
        return this.then;
    }

    public Optional<DataType> getDataTypeOutput() {
        return this.dataTypeOutput;
    }

    private static Tag convertToTag(byte tag, double originalValue) {
        switch (tag) {
            case 1: {
                return ByteTag.m_128266_((byte)((byte)originalValue));
            }
            case 3: {
                return IntTag.m_128679_((int)((int)originalValue));
            }
            case 6: {
                return DoubleTag.m_128500_((double)originalValue);
            }
            case 5: {
                return FloatTag.m_128566_((float)((float)originalValue));
            }
            case 4: {
                return LongTag.m_128882_((long)((long)originalValue));
            }
            case 2: {
                return ShortTag.m_129258_((short)((short)originalValue));
            }
        }
        throw new IllegalArgumentException("Unexpected value: " + originalValue);
    }

    public static enum OperatorType {
        GEQUALS(">=", (a, b) -> ((NumericTag)a).m_7061_() >= b),
        EQUALS("==", (a, b) -> ((NumericTag)a).m_7061_() > b),
        LEQUALS("<=", (a, b) -> ((NumericTag)a).m_7061_() <= b),
        LESS("<", (a, b) -> ((NumericTag)a).m_7061_() < b),
        GREATER(">", (a, b) -> ((NumericTag)a).m_7061_() > b);

        private static LazyOptional<HashMap<String, OperatorType>> operators;
        private String operatorName;
        private BiPredicate<Tag, Double> operation;

        private OperatorType(String operatorName, BiPredicate<Tag, Double> operation) {
            this.operatorName = operatorName;
            this.operation = operation;
        }

        public boolean applyOperation(Tag leftSide, double rightSide) {
            return this.operation.test(leftSide, rightSide);
        }

        public String getOperatorName() {
            return this.operatorName;
        }

        public static OperatorType getOperatorByName(String operator) {
            return (OperatorType)((Object)((HashMap)operators.resolve().get()).get(operator));
        }

        static {
            operators = LazyOptional.of(() -> {
                HashMap<String, OperatorType> opMap = new HashMap<String, OperatorType>();
                for (OperatorType type : OperatorType.values()) {
                    opMap.put(type.getOperatorName(), type);
                }
                return opMap;
            });
        }
    }

    public static enum DataType {
        BYTE("byte", 1),
        SHORT("short", 2),
        INT("int", 3),
        LONG("long", 4),
        FLOAT("float", 5),
        DOUBLE("double", 6);

        private static LazyOptional<HashMap<String, DataType>> types;
        private String dataTypeName;
        private byte dataTypeId;

        private DataType(String dataTypeName, byte dataTypeId) {
            this.dataTypeName = dataTypeName;
            this.dataTypeId = dataTypeId;
        }

        public byte getDataTypeId() {
            return this.dataTypeId;
        }

        public String getDataTypeName() {
            return this.dataTypeName;
        }

        public static DataType getDataTypeByName(String name) {
            return (DataType)((Object)((HashMap)types.resolve().get()).get(name));
        }

        static {
            types = LazyOptional.of(() -> {
                HashMap<String, DataType> dMap = new HashMap<String, DataType>();
                for (DataType type : DataType.values()) {
                    dMap.put(type.getDataTypeName(), type);
                }
                return dMap;
            });
        }
    }
}

