/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.data_transformers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.budschie.bmorph.morph.functionality.data_transformers.DataModifier;
import java.text.MessageFormat;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataModifierHolder<T extends DataModifier>
extends ForgeRegistryEntry<DataModifierHolder<? extends DataModifier>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private Codec<T> dataModifierCodec;

    public DataModifierHolder(Codec<T> dataModifierCodec) {
        this.dataModifierCodec = dataModifierCodec;
    }

    public Codec<T> getCodec() {
        return this.dataModifierCodec;
    }

    public Optional<? extends DataModifier> deserializeJson(JsonElement object) {
        Optional optAbility = this.dataModifierCodec.decode((DynamicOps)JsonOps.INSTANCE, (Object)object).resultOrPartial(err -> LOGGER.warn("Received bad data when parsing data modifier: " + err));
        if (optAbility.isPresent()) {
            ((DataModifier)((Pair)optAbility.get()).getFirst()).setDataModifierHolder(this);
            return Optional.of((DataModifier)((Pair)optAbility.get()).getFirst());
        }
        return Optional.empty();
    }

    public Optional<? extends DataModifier> deserializeNbt(CompoundTag nbt) {
        Optional optAbility = this.dataModifierCodec.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).resultOrPartial(err -> LOGGER.warn("Received bad data when parsing data modifier: " + err));
        if (optAbility.isPresent()) {
            ((DataModifier)((Pair)optAbility.get()).getFirst()).setDataModifierHolder(this);
            return Optional.of((DataModifier)((Pair)optAbility.get()).getFirst());
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> serializeNBT(T modifier) {
        DataResult nbt = this.getCodec().encodeStart((DynamicOps)NbtOps.f_128958_, modifier);
        if (nbt.get().left().isPresent()) {
            if (nbt.get().left().get() instanceof CompoundTag) {
                return Optional.of((CompoundTag)nbt.get().left().get());
            }
            return Optional.of(new CompoundTag());
        }
        LOGGER.warn(MessageFormat.format("There was an error serializing a data modifier with its codec {0}: {1}", this.getRegistryName(), ((DataResult.PartialResult)nbt.get().right().get()).message()));
        return Optional.empty();
    }

    public Optional<CompoundTag> serializeNBTIAmTooDumbForJava(DataModifier modifier) {
        if (modifier.getDataModifierHolder() == this) {
            return this.serializeNBT(modifier);
        }
        throw new UnsupportedOperationException("You can only call this on the data modifier that belongs to you. If you see this error message, please consider filing a bug report at my GitHub page.");
    }
}

