/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.morph.functionality.data_transformers;

import de.budschie.bmorph.json_integration.NBTPath;
import de.budschie.bmorph.morph.functionality.data_transformers.DataModifier;
import de.budschie.bmorph.morph.functionality.data_transformers.DataModifierHolder;
import de.budschie.bmorph.morph.functionality.data_transformers.DataModifierRegistry;
import de.budschie.bmorph.util.IDynamicRegistryObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataTransformer
implements IDynamicRegistryObject {
    private static final Logger LOGGER = LogManager.getLogger();
    private ResourceLocation name;
    private NBTPath source;
    private NBTPath destination;
    private List<DataModifier> modifiers;

    public DataTransformer(NBTPath source, NBTPath destination, List<DataModifier> modifiers) {
        this.source = source;
        this.destination = destination;
        this.modifiers = modifiers;
    }

    public static DataTransformer valueOf(CompoundTag compoundTag) {
        ResourceLocation resourceLocation = new ResourceLocation(compoundTag.m_128461_("TransformerId"));
        NBTPath src = NBTPath.valueOf(compoundTag.m_128461_("NbtSrc"));
        NBTPath dest = NBTPath.valueOf(compoundTag.m_128461_("NbtDest"));
        ArrayList<DataModifier> modifiers = new ArrayList<DataModifier>();
        int length = compoundTag.m_128451_("Length");
        for (int i = 0; i < length; ++i) {
            CompoundTag modifierTag = compoundTag.m_128469_(Integer.valueOf(i).toString());
            ResourceLocation modifierId = new ResourceLocation(modifierTag.m_128461_("ModifierId"));
            DataModifierHolder modifierHolder = (DataModifierHolder)DataModifierRegistry.REGISTRY.get().getValue(modifierId);
            if (modifierHolder == null) {
                LOGGER.error(MessageFormat.format("Skipped data modifier with illegal type id {0} whilst deserializing data transformer {1}. If you see this, please report it as a bug.", modifierId, resourceLocation));
                continue;
            }
            Optional<DataModifier> dataModifier = modifierHolder.deserializeNbt(modifierTag.m_128469_("Data"));
            if (dataModifier.isPresent()) {
                modifiers.add(dataModifier.get());
                continue;
            }
            LOGGER.error(MessageFormat.format("Skipped data modifier of type {0} whilst deserializing data transformer {1}. If you see this, please report it as a bug.", modifierHolder.getRegistryName(), resourceLocation));
        }
        DataTransformer transformer = new DataTransformer(src, dest, modifiers);
        transformer.setResourceLocation(resourceLocation);
        return transformer;
    }

    public void transformData(CompoundTag dataRootSource, CompoundTag dataRootDestination) {
        Optional<Tag> originalTag = this.source.resolveOptional(dataRootSource);
        for (DataModifier modifier : this.modifiers) {
            if (!modifier.canOperateOn(originalTag)) continue;
            originalTag = modifier.applyModifier(originalTag);
        }
        if (originalTag.isPresent()) {
            this.destination.setTag(dataRootDestination, originalTag.get());
        }
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("TransformerId", this.getResourceLocation().toString());
        int i = 0;
        for (DataModifier modifier : this.modifiers) {
            DataModifier currentMod = this.modifiers.get(i);
            Optional<CompoundTag> toSerialize = currentMod.serializeNbt();
            if (toSerialize.isPresent()) {
                CompoundTag modTag = new CompoundTag();
                modTag.m_128359_("ModifierId", modifier.getDataModifierHolder().getRegistryName().toString());
                modTag.m_128365_("Data", (Tag)toSerialize.get());
                tag.m_128365_(Integer.valueOf(i++).toString(), (Tag)modTag);
                continue;
            }
            LOGGER.warn(MessageFormat.format("Skipped data modifier of type {0} in {1} because it could not be serialized. This data can consequently not be used. Skipping this modifier.", modifier.getDataModifierHolder().getRegistryName(), this.getResourceLocation()));
        }
        tag.m_128405_("Length", i);
        tag.m_128359_("NbtSrc", this.source.toString());
        tag.m_128359_("NbtDest", this.destination.toString());
        return tag;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.name;
    }

    @Override
    public void setResourceLocation(ResourceLocation name) {
        this.name = name;
    }
}

