/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.json_integration.ability_groups.AbilityGroupRegistry;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.network.ISimpleImplPacket;
import de.budschie.bmorph.util.Pair;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbilityGroupSync
implements ISimpleImplPacket<AbilityGroupSyncPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void encode(AbilityGroupSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.getAbilityGroups().size());
        Iterator<AbilityGroupRegistry.AbilityGroup> abilityGroupiterator = packet.getAbilityGroups().iterator();
        for (int i = 0; i < packet.getAbilityGroups().size(); ++i) {
            AbilityGroupRegistry.AbilityGroup group = abilityGroupiterator.next();
            buffer.m_130070_(group.getResourceLocation().toString());
            buffer.writeInt(group.getAbilities().size());
            Iterator<Ability> abilityIterator = group.getAbilities().iterator();
            for (int j = 0; j < group.getAbilities().size(); ++j) {
                buffer.m_130070_(abilityIterator.next().getResourceLocation().toString());
            }
        }
    }

    @Override
    public AbilityGroupSyncPacket decode(FriendlyByteBuf buffer) {
        ArrayList<Pair<ResourceLocation, ? extends Collection<ResourceLocation>>> receivedData = new ArrayList<Pair<ResourceLocation, ? extends Collection<ResourceLocation>>>();
        int abilityGroupLength = buffer.readInt();
        for (int i = 0; i < abilityGroupLength; ++i) {
            ResourceLocation rlGroup = new ResourceLocation(buffer.m_130277_());
            int abilityListLength = buffer.readInt();
            ArrayList<ResourceLocation> rlAbilityList = new ArrayList<ResourceLocation>();
            for (int j = 0; j < abilityListLength; ++j) {
                rlAbilityList.add(new ResourceLocation(buffer.m_130277_()));
            }
            receivedData.add(new Pair(rlGroup, rlAbilityList));
        }
        return AbilityGroupSyncPacket.clientPacket(receivedData);
    }

    @Override
    public void handle(AbilityGroupSyncPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BMorphMod.ABILITY_GROUPS.setFillRegistry(() -> {
                for (Pair<ResourceLocation, ? extends Collection<ResourceLocation>> groupTupel : packet.getToResolve()) {
                    AbilityGroupRegistry.AbilityGroup group = new AbilityGroupRegistry.AbilityGroup(groupTupel.getA());
                    for (ResourceLocation abilityRl : groupTupel.getB()) {
                        Ability resolved = (Ability)BMorphMod.DYNAMIC_ABILITY_REGISTRY.getEntry(abilityRl);
                        if (resolved == null) {
                            LOGGER.warn(MessageFormat.format("Failed to resolve ability {0} of ability group {1} as said ability doesn't exist. This is an error with the mod, please report it to the mod author!", abilityRl.toString(), groupTupel.getA().toString()));
                            continue;
                        }
                        group.addAbility(resolved);
                    }
                    BMorphMod.ABILITY_GROUPS.registerEntry(group);
                }
            });
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static class AbilityGroupSyncPacket {
        private Collection<AbilityGroupRegistry.AbilityGroup> abilityGroups;
        private Collection<Pair<ResourceLocation, ? extends Collection<ResourceLocation>>> toResolve;

        private AbilityGroupSyncPacket() {
        }

        public static AbilityGroupSyncPacket serverPacket(Collection<AbilityGroupRegistry.AbilityGroup> abilityGroups) {
            AbilityGroupSyncPacket packet = new AbilityGroupSyncPacket();
            packet.abilityGroups = abilityGroups;
            return packet;
        }

        public static AbilityGroupSyncPacket clientPacket(Collection<Pair<ResourceLocation, ? extends Collection<ResourceLocation>>> toResolve) {
            AbilityGroupSyncPacket packet = new AbilityGroupSyncPacket();
            packet.toResolve = toResolve;
            return packet;
        }

        public Collection<AbilityGroupRegistry.AbilityGroup> getAbilityGroups() {
            return this.abilityGroups;
        }

        public Collection<Pair<ResourceLocation, ? extends Collection<ResourceLocation>>> getToResolve() {
            return this.toResolve;
        }
    }
}

