/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdditionalAbilitySynchronization
implements ISimpleImplPacket<AdditionalAbilitySynchronizationPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void encode(AdditionalAbilitySynchronizationPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.getPlayer());
        buffer.writeBoolean(packet.shouldAdd());
        buffer.writeInt(packet.getAbilities().length);
        for (String ability : packet.getAbilities()) {
            buffer.m_130070_(ability);
        }
    }

    @Override
    public AdditionalAbilitySynchronizationPacket decode(FriendlyByteBuf buffer) {
        UUID player = buffer.m_130259_();
        boolean add = buffer.readBoolean();
        int abilityLength = buffer.readInt();
        String[] abilities = new String[abilityLength];
        for (int i = 0; i < abilityLength; ++i) {
            abilities[i] = buffer.m_130277_();
        }
        return new AdditionalAbilitySynchronizationPacket(player, add, abilities);
    }

    @Override
    public void handle(AdditionalAbilitySynchronizationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                Player player = Minecraft.m_91087_().f_91073_.m_46003_(packet.getPlayer());
                if (player == null) {
                    LOGGER.info(MessageFormat.format("The player {0} was not found when trying to synchronize abilities.", packet.getPlayer().toString()));
                } else {
                    ArrayList<Ability> resolvedAbilities = new ArrayList<Ability>();
                    for (String rawAbility : packet.getAbilities()) {
                        Ability retrievedAbility = (Ability)BMorphMod.DYNAMIC_ABILITY_REGISTRY.getEntry(new ResourceLocation(rawAbility));
                        if (retrievedAbility == null) {
                            LOGGER.info(MessageFormat.format("The ability {0} could not be resolved; it doesn't exist on the client. Please report this as a bug.", rawAbility));
                            continue;
                        }
                        resolvedAbilities.add(retrievedAbility);
                    }
                    MorphUtil.processCap(player, arg_0 -> AdditionalAbilitySynchronization.lambda$handle$0(resolvedAbilities, packet, (Supplier)ctx, arg_0));
                }
            }
        });
    }

    private static /* synthetic */ void lambda$handle$0(ArrayList resolvedAbilities, AdditionalAbilitySynchronizationPacket packet, Supplier ctx, IMorphCapability cap) {
        for (Ability ability : resolvedAbilities) {
            if (packet.add) {
                cap.applyAbility(ability);
                continue;
            }
            cap.deapplyAbility(ability);
        }
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }

    public static class AdditionalAbilitySynchronizationPacket {
        private UUID player;
        private boolean add;
        private String[] abilities;

        public AdditionalAbilitySynchronizationPacket(UUID player, boolean add, Ability ... abilities) {
            this.player = player;
            this.add = add;
            this.abilities = new String[abilities.length];
            for (int i = 0; i < abilities.length; ++i) {
                this.abilities[i] = abilities[i].getResourceLocation().toString();
            }
        }

        public AdditionalAbilitySynchronizationPacket(UUID player, boolean add, String ... abilities) {
            this.player = player;
            this.add = add;
            this.abilities = abilities;
        }

        public boolean shouldAdd() {
            return this.add;
        }

        public String[] getAbilities() {
            return this.abilities;
        }

        public UUID getPlayer() {
            return this.player;
        }
    }
}

