/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.functionality.Ability;
import de.budschie.bmorph.morph.functionality.AbilityRegistry;
import de.budschie.bmorph.morph.functionality.configurable.ConfigurableAbility;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class ConfiguredAbilitySynchronizer
implements ISimpleImplPacket<ConfiguredAbilityPacket> {
    @Override
    public void encode(ConfiguredAbilityPacket packet, FriendlyByteBuf buffer) {
        for (Ability ability : packet.getAbilities()) {
            Optional<CompoundTag> serialized = ability.getConfigurableAbility().serializeNBTIAmTooDumbForJava(ability);
            if (!serialized.isPresent()) continue;
            buffer.m_130070_(ability.getResourceLocation().toString());
            buffer.m_130070_(ability.getConfigurableAbility().getRegistryName().toString());
            buffer.m_130079_(serialized.get());
        }
        buffer.m_130070_("");
    }

    @Override
    public ConfiguredAbilityPacket decode(FriendlyByteBuf buffer) {
        String abilityName;
        ArrayList<Ability> abilities = new ArrayList<Ability>();
        while (!(abilityName = buffer.m_130277_()).isEmpty()) {
            String configurableAbilityName = buffer.m_130277_();
            CompoundTag nbt = buffer.m_130260_();
            ConfigurableAbility configurableAbility = (ConfigurableAbility)AbilityRegistry.REGISTRY.get().getValue(new ResourceLocation(configurableAbilityName));
            Optional<Ability> parsedAbility = configurableAbility.deserializeNBT(nbt);
            if (!parsedAbility.isPresent()) continue;
            parsedAbility.get().setResourceLocation(new ResourceLocation(abilityName));
            abilities.add(parsedAbility.get());
        }
        return new ConfiguredAbilityPacket(abilities);
    }

    @Override
    public void handle(ConfiguredAbilityPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BMorphMod.DYNAMIC_ABILITY_REGISTRY.unregisterAll();
            packet.getAbilities().forEach(ability -> BMorphMod.DYNAMIC_ABILITY_REGISTRY.registerEntry(ability));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static class ConfiguredAbilityPacket {
        private Collection<Ability> abilities;

        public ConfiguredAbilityPacket(Collection<Ability> abilities) {
            this.abilities = abilities;
        }

        public Collection<Ability> getAbilities() {
            return this.abilities;
        }
    }
}

