/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.morph.functionality.data_transformers.DataTransformer;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class DataTransformerSynchronizer
implements ISimpleImplPacket<DataTransfomerSynchronizerPacket> {
    @Override
    public void encode(DataTransfomerSynchronizerPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.getDataTransformers().size());
        for (DataTransformer transformer : packet.getDataTransformers()) {
            buffer.m_130079_(transformer.toNbt());
        }
    }

    @Override
    public DataTransfomerSynchronizerPacket decode(FriendlyByteBuf buffer) {
        ArrayList<DataTransformer> deserializedTransformers = new ArrayList<DataTransformer>();
        int dataTransformerAmount = buffer.readInt();
        for (int i = 0; i < dataTransformerAmount; ++i) {
            deserializedTransformers.add(DataTransformer.valueOf(buffer.m_130260_()));
        }
        return new DataTransfomerSynchronizerPacket(deserializedTransformers);
    }

    @Override
    public void handle(DataTransfomerSynchronizerPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BMorphMod.DYNAMIC_DATA_TRANSFORMER_REGISTRY.unregisterAll();
            for (DataTransformer transformer : packet.getDataTransformers()) {
                BMorphMod.DYNAMIC_DATA_TRANSFORMER_REGISTRY.registerEntry(transformer);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static class DataTransfomerSynchronizerPacket {
        private Collection<DataTransformer> dataTransformers;

        public DataTransfomerSynchronizerPacket(Collection<DataTransformer> dataTransformers) {
            this.dataTransformers = dataTransformers;
        }

        public Collection<DataTransformer> getDataTransformers() {
            return this.dataTransformers;
        }
    }
}

