/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.entity.MorphEntity;
import de.budschie.bmorph.main.BMorphMod;
import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteOrDropMorph
implements ISimpleImplPacket<DeleteOrDropMorphPacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void encode(DeleteOrDropMorphPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.getIndex());
        buffer.writeBoolean(packet.shouldDrop());
    }

    @Override
    public DeleteOrDropMorphPacket decode(FriendlyByteBuf buffer) {
        return new DeleteOrDropMorphPacket(buffer.readInt(), buffer.readBoolean());
    }

    @Override
    public void handle(DeleteOrDropMorphPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (packet.drop && !ServerSetup.server.m_129900_().m_46207_(BMorphMod.ALLOW_MORPH_DROPPING) || !packet.drop && !ServerSetup.server.m_129900_().m_46207_(BMorphMod.ALLOW_MORPH_DELETION)) {
            return;
        }
        ctx.get().enqueueWork(() -> MorphUtil.processCap((Player)((NetworkEvent.Context)ctx.get()).getSender(), arg_0 -> DeleteOrDropMorph.lambda$handle$0(packet, (Supplier)ctx, arg_0)));
    }

    private static /* synthetic */ void lambda$handle$0(DeleteOrDropMorphPacket packet, Supplier ctx, IMorphCapability cap) {
        if (packet.getIndex() >= cap.getMorphList().getMorphArrayList().size() || packet.getIndex() < 0) {
            LOGGER.warn(String.format("Client %s tried to parse in bad morph item index when sending the DeleteOrDropMorph packet; we got %s and expected a number from 0 - %s (non-inclusive).", ((NetworkEvent.Context)ctx.get()).getSender().m_7755_(), packet.getIndex(), cap.getMorphList().getMorphArrayList().size()));
            return;
        }
        MorphItem morph = cap.getMorphList().getMorphArrayList().get(packet.getIndex());
        if (cap.getCurrentMorphIndex().isPresent() && morph == cap.getMorphList().getMorphArrayList().get(cap.getCurrentMorphIndex().get())) {
            MorphUtil.morphToServer(Optional.empty(), Optional.empty(), (Player)((NetworkEvent.Context)ctx.get()).getSender());
        }
        cap.getMorphList().removeFromMorphList(packet.getIndex());
        cap.syncMorphRemoval(packet.getIndex());
        if (packet.shouldDrop()) {
            ServerLevel level = ((NetworkEvent.Context)ctx.get()).getSender().m_183503_();
            MorphEntity morphEntity = new MorphEntity((Level)level, morph, 69);
            morphEntity.m_146884_(((NetworkEvent.Context)ctx.get()).getSender().m_20182_());
            level.m_7967_((Entity)morphEntity);
        }
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }

    public static class DeleteOrDropMorphPacket {
        private int index;
        private boolean drop;

        public DeleteOrDropMorphPacket(int index, boolean drop) {
            this.index = index;
            this.drop = drop;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean shouldDrop() {
            return this.drop;
        }
    }
}

