/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.common.CommonCapabilitySynchronizer;
import de.budschie.bmorph.capabilities.phantom_glide.ChargeDirection;
import de.budschie.bmorph.capabilities.phantom_glide.GlideCapabilityInstance;
import de.budschie.bmorph.capabilities.phantom_glide.GlideStatus;
import de.budschie.bmorph.capabilities.phantom_glide.IGlideCapability;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class GlideStatusChange
extends CommonCapabilitySynchronizer<GlideStatusChangePacket, IGlideCapability> {
    public GlideStatusChange() {
        super(GlideCapabilityInstance.GLIDE_CAP);
    }

    @Override
    public void encodeAdditional(GlideStatusChangePacket packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.getGlideStatus().name());
        buffer.writeInt(packet.getChargeTime());
        buffer.writeInt(packet.getMaxChargeTime());
        buffer.writeInt(packet.getTransitionTime());
        if (packet.getChargeDirection() != null) {
            buffer.writeBoolean(true);
            buffer.m_130070_(packet.getChargeDirection().name());
        } else {
            buffer.writeBoolean(false);
        }
    }

    @Override
    public GlideStatusChangePacket decodeAdditional(FriendlyByteBuf buffer) {
        String glideStatus = buffer.m_130277_();
        int chargeTime = buffer.readInt();
        int maxChargeTime = buffer.readInt();
        int transitionTime = buffer.readInt();
        ChargeDirection chargeDir = null;
        if (buffer.readBoolean()) {
            chargeDir = ChargeDirection.valueOf(buffer.m_130277_());
        }
        return new GlideStatusChangePacket(GlideStatus.valueOf(glideStatus), chargeTime, maxChargeTime, transitionTime, chargeDir);
    }

    @Override
    public boolean handleCapabilitySync(GlideStatusChangePacket packet, Supplier<NetworkEvent.Context> ctx, Player player, IGlideCapability capabilityInterface) {
        capabilityInterface.setGlideStatus(packet.getGlideStatus(), player);
        capabilityInterface.setChargeTime(packet.getChargeTime());
        capabilityInterface.setMaxChargeTime(packet.getMaxChargeTime());
        capabilityInterface.setTransitionTime(packet.getTransitionTime());
        capabilityInterface.setMaxTransitionTime(packet.getTransitionTime());
        capabilityInterface.setChargeDirection(packet.getChargeDirection());
        return true;
    }

    public static class GlideStatusChangePacket
    extends CommonCapabilitySynchronizer.CommonCapabilitySynchronizerPacket {
        private GlideStatus glideStatus;
        private int chargeTime;
        private int maxChargeTime;
        private int transitionTime;
        private ChargeDirection chargeDirection;

        public GlideStatusChangePacket(GlideStatus glideStatus, int chargeTime, int maxChargeTime, int transitionTime, ChargeDirection chargeDirection) {
            this.chargeTime = chargeTime;
            this.maxChargeTime = maxChargeTime;
            this.transitionTime = transitionTime;
            this.glideStatus = glideStatus;
            this.chargeDirection = chargeDirection;
        }

        public int getChargeTime() {
            return this.chargeTime;
        }

        public int getMaxChargeTime() {
            return this.maxChargeTime;
        }

        public GlideStatus getGlideStatus() {
            return this.glideStatus;
        }

        public ChargeDirection getChargeDirection() {
            return this.chargeDirection;
        }

        public int getTransitionTime() {
            return this.transitionTime;
        }
    }
}

