/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.gui.MorphGuiHandler;
import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class MorphAddedSynchronizer
implements ISimpleImplPacket<MorphAddedPacket> {
    @Override
    public void encode(MorphAddedPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.getPlayerUUID());
        buffer.m_130079_(packet.getAddedMorph().serialize());
    }

    @Override
    public MorphAddedPacket decode(FriendlyByteBuf buffer) {
        return new MorphAddedPacket(buffer.m_130259_(), MorphHandler.deserializeMorphItem(buffer.m_130260_()));
    }

    @Override
    public void handle(MorphAddedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                LazyOptional cap = Minecraft.m_91087_().f_91073_.m_46003_(packet.getPlayerUUID()).getCapability(MorphCapabilityAttacher.MORPH_CAP);
                if (cap.isPresent()) {
                    IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                    resolved.addToMorphList(packet.getAddedMorph());
                }
                MorphGuiHandler.updateMorphUi();
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        });
    }

    public static class MorphAddedPacket {
        UUID playerUUID;
        MorphItem addedMorph;

        public MorphAddedPacket(UUID playerUUID, MorphItem addedMorph) {
            this.playerUUID = playerUUID;
            this.addedMorph = addedMorph;
        }

        public MorphItem getAddedMorph() {
            return this.addedMorph;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }
    }
}

