/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.morph.MorphHandler;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MorphChangedSynchronizer
implements ISimpleImplPacket<MorphChangedPacket> {
    @Override
    public void encode(MorphChangedPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.getPlayerUUID());
        buffer.writeBoolean(packet.getMorphIndex().isPresent());
        buffer.writeBoolean(packet.getMorphItem().isPresent());
        packet.getMorphIndex().ifPresent(index -> buffer.writeInt(index.intValue()));
        packet.getMorphItem().ifPresent(item -> buffer.m_130079_(item.serialize()));
        buffer.writeInt(packet.getAbilities().size());
        for (String str : packet.getAbilities()) {
            buffer.m_130070_(str);
        }
    }

    @Override
    public MorphChangedPacket decode(FriendlyByteBuf buffer) {
        UUID playerUUID = buffer.m_130259_();
        boolean hasIndex = buffer.readBoolean();
        boolean hasItem = buffer.readBoolean();
        Optional<Integer> morphIndex = Optional.empty();
        Optional<MorphItem> morphItem = Optional.empty();
        if (hasIndex) {
            morphIndex = Optional.of(buffer.readInt());
        }
        if (hasItem) {
            morphItem = Optional.of(MorphHandler.deserializeMorphItem(buffer.m_130260_()));
        }
        int amountOfAbilities = buffer.readInt();
        ArrayList<String> abilities = new ArrayList<String>(amountOfAbilities);
        for (int i = 0; i < amountOfAbilities; ++i) {
            abilities.add(buffer.m_130277_());
        }
        return new MorphChangedPacket(playerUUID, morphIndex, morphItem, abilities);
    }

    @Override
    public void handle(MorphChangedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                MorphUtil.morphToClient(packet.getMorphItem(), packet.getMorphIndex(), packet.getAbilities(), Minecraft.m_91087_().f_91073_.m_46003_(packet.getPlayerUUID()));
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        });
    }

    public static class MorphChangedPacket {
        UUID playerUUID;
        Optional<Integer> morphIndex;
        Optional<MorphItem> morphItem;
        ArrayList<String> abilities;

        public MorphChangedPacket(UUID playerUUID, Optional<Integer> morphIndex, Optional<MorphItem> morphItem, ArrayList<String> abilities) {
            this.playerUUID = playerUUID;
            this.morphIndex = morphIndex;
            this.morphItem = morphItem;
            this.abilities = abilities;
        }

        public Optional<Integer> getMorphIndex() {
            return this.morphIndex;
        }

        public Optional<MorphItem> getMorphItem() {
            return this.morphItem;
        }

        public ArrayList<String> getAbilities() {
            return this.abilities;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }
    }
}

