/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.gui.MorphGuiHandler;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class MorphRemovedSynchronizer
implements ISimpleImplPacket<MorphRemovedPacket> {
    @Override
    public void encode(MorphRemovedPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.getPlayerUUID());
        buffer.writeInt(packet.getRemovedMorph());
    }

    @Override
    public MorphRemovedPacket decode(FriendlyByteBuf buffer) {
        return new MorphRemovedPacket(buffer.m_130259_(), buffer.readInt());
    }

    @Override
    public void handle(MorphRemovedPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91073_ != null) {
                LazyOptional cap = Minecraft.m_91087_().f_91073_.m_46003_(packet.getPlayerUUID()).getCapability(MorphCapabilityAttacher.MORPH_CAP);
                if (cap.isPresent()) {
                    IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                    resolved.removeFromMorphList(packet.getRemovedMorph());
                }
                MorphGuiHandler.updateMorphUi();
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        });
    }

    public static class MorphRemovedPacket {
        UUID playerUUID;
        int removedMorph;

        public MorphRemovedPacket(UUID playerUUID, int removedMorph) {
            this.playerUUID = playerUUID;
            this.removedMorph = removedMorph;
        }

        public int getRemovedMorph() {
            return this.removedMorph;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }
    }
}

