/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.capabilities.blacklist.BlacklistData;
import de.budschie.bmorph.capabilities.blacklist.ConfigManager;
import de.budschie.bmorph.morph.MorphUtil;
import de.budschie.bmorph.network.ISimpleImplPacket;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class MorphRequestMorphIndexChange
implements ISimpleImplPacket<RequestMorphIndexChangePacket> {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public void encode(RequestMorphIndexChangePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.requestedIndex);
    }

    @Override
    public RequestMorphIndexChangePacket decode(FriendlyByteBuf buffer) {
        return new RequestMorphIndexChangePacket(buffer.readInt());
    }

    @Override
    public void handle(RequestMorphIndexChangePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LazyOptional cap = ((NetworkEvent.Context)ctx.get()).getSender().getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (cap.isPresent()) {
                IMorphCapability resolved = (IMorphCapability)cap.resolve().get();
                if (packet.getRequestedIndex() == -1) {
                    MorphUtil.morphToServer(Optional.empty(), Optional.empty(), (Player)((NetworkEvent.Context)ctx.get()).getSender());
                } else if (packet.getRequestedIndex() >= resolved.getMorphList().getMorphArrayList().size() || packet.getRequestedIndex() < 0) {
                    LOGGER.warn((Object)MessageFormatter.format((String)"Player {0} with UUID {1} has tried to send invalid data!", (Object)((NetworkEvent.Context)ctx.get()).getSender().m_7755_().getString(), (Object)((NetworkEvent.Context)ctx.get()).getSender().m_142081_()));
                } else {
                    boolean shouldMorph;
                    ResourceLocation morphToRS = resolved.getMorphList().getMorphArrayList().get(packet.getRequestedIndex()).getEntityType().getRegistryName();
                    boolean bl = shouldMorph = !ConfigManager.INSTANCE.get(BlacklistData.class).isInBlacklist(morphToRS);
                    if (shouldMorph) {
                        MorphUtil.morphToServer(Optional.empty(), Optional.of(packet.getRequestedIndex()), (Player)((NetworkEvent.Context)ctx.get()).getSender());
                    } else {
                        ((NetworkEvent.Context)ctx.get()).getSender().m_6352_((Component)new TextComponent(ChatFormatting.RED + "I'm sorry but you can't morph into " + morphToRS.toString() + " as this entity is currently blacklisted."), Util.f_137441_);
                    }
                }
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
    }

    public static class RequestMorphIndexChangePacket {
        int requestedIndex;

        public RequestMorphIndexChangePacket(int requestedIndex) {
            this.requestedIndex = requestedIndex;
        }

        public int getRequestedIndex() {
            return this.requestedIndex;
        }
    }
}

