/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.network;

import de.budschie.bmorph.capabilities.common.CommonCapabilitySynchronizer;
import de.budschie.bmorph.capabilities.sheep.ISheepCapability;
import de.budschie.bmorph.capabilities.sheep.SheepCapabilityInstance;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MorphSheepSheared
extends CommonCapabilitySynchronizer<MorphSheepShearedPacket, ISheepCapability> {
    public MorphSheepSheared() {
        super(SheepCapabilityInstance.SHEEP_CAP);
    }

    @Override
    public void encodeAdditional(MorphSheepShearedPacket packet, FriendlyByteBuf buffer) {
        buffer.writeBoolean(packet.isSheared());
    }

    @Override
    public MorphSheepShearedPacket decodeAdditional(FriendlyByteBuf buffer) {
        return new MorphSheepShearedPacket(buffer.readBoolean());
    }

    @Override
    public boolean handleCapabilitySync(MorphSheepShearedPacket packet, Supplier<NetworkEvent.Context> ctx, Player player, ISheepCapability capabilityInterface) {
        capabilityInterface.setSheared(packet.isSheared());
        return true;
    }

    public static class MorphSheepShearedPacket
    extends CommonCapabilitySynchronizer.CommonCapabilitySynchronizerPacket {
        private boolean sheared;

        public MorphSheepShearedPacket(boolean sheared) {
            this.sheared = sheared;
        }

        public boolean isSheared() {
            return this.sheared;
        }
    }
}

