/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.predicates;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.budschie.bmorph.advancements.predicates.MorphPredicate;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.MorphUtil;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class PlayerAttributesPredicate
implements LootItemCondition {
    private MinMaxBounds.Doubles playerHealth;
    private MorphPredicate morphPredicate;

    public PlayerAttributesPredicate(MinMaxBounds.Doubles playerHealth, MorphPredicate morphPredicate) {
        this.playerHealth = playerHealth;
        this.morphPredicate = morphPredicate;
    }

    public boolean test(LootContext t) {
        Player player = null;
        if (t.m_78936_(LootContextParams.f_81455_)) {
            Object object = t.m_165124_(LootContextParams.f_81455_);
            if (object instanceof Player) {
                Player castedPlayer;
                player = castedPlayer = (Player)object;
            } else {
                return false;
            }
        }
        if (this.playerHealth != null && !this.playerHealth.m_154810_((double)player.m_21223_())) {
            return false;
        }
        if (this.morphPredicate != null) {
            IMorphCapability cap = MorphUtil.getCapOrNull(player);
            if (cap == null) {
                return false;
            }
            MorphItem morphItem = cap.getCurrentMorph().orElse(null);
            if (morphItem == null || !this.morphPredicate.matches(morphItem, cap)) {
                return false;
            }
        }
        return true;
    }

    public LootItemConditionType m_7940_() {
        return new LootItemConditionType((net.minecraft.world.level.storage.loot.Serializer)new Serializer());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<PlayerAttributesPredicate> {
        public void serialize(JsonObject pJson, PlayerAttributesPredicate pValue, JsonSerializationContext pSerializationContext) {
            if (pValue.playerHealth != null) {
                pJson.add("player_health", pValue.playerHealth.m_55328_());
            }
            if (pValue.morphPredicate != null) {
                pJson.add("current_morph", pValue.morphPredicate.serializeToJson());
            }
        }

        public PlayerAttributesPredicate deserialize(JsonObject pJson, JsonDeserializationContext pSerializationContext) {
            MinMaxBounds.Doubles playerHealth = null;
            MorphPredicate morphPredicate = null;
            if (pJson.has("player_health")) {
                playerHealth = MinMaxBounds.Doubles.m_154791_((JsonElement)pJson.get("player_health"));
            }
            if (pJson.has("current_morph")) {
                morphPredicate = MorphPredicate.fromJson(pJson.get("current_morph"));
            }
            return new PlayerAttributesPredicate(playerHealth, morphPredicate);
        }
    }
}

