/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.render_handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.budschie.bmorph.capabilities.guardian.GuardianBeamCapabilityInstance;
import de.budschie.bmorph.capabilities.guardian.IGuardianBeamCapability;
import de.budschie.bmorph.render_handler.IEntitySynchronizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuardianEntitySynchronizer
implements IEntitySynchronizer {
    @Override
    public boolean appliesToMorph(Entity morphEntity) {
        return morphEntity instanceof Guardian;
    }

    @Override
    public void applyToMorphEntity(Entity morphEntity, Player player) {
        IGuardianBeamCapability beamCap = player.getCapability(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP).resolve().orElse(null);
        if (beamCap != null) {
            float tailAnimationSpeed;
            Guardian casted = (Guardian)morphEntity;
            casted.f_32804_ = beamCap.getAttackProgression();
            if (beamCap.getAttackedEntity().isPresent()) {
                casted.m_32817_(beamCap.getAttackedEntity().get().intValue());
            } else {
                casted.m_32817_(0);
            }
            casted.f_32805_ = casted.m_20184_().f_82480_ < 0.0 && casted.f_19853_.m_46575_(casted.m_142538_().m_7495_(), (Entity)casted);
            casted.f_32802_ = casted.f_32801_;
            casted.f_32801_ += (1.0f - casted.f_32801_) * 0.06f;
            casted.f_32799_ = casted.f_32798_;
            float f = tailAnimationSpeed = casted.m_20069_() ? 0.4f : 0.2f;
            if (player.m_20184_().m_82556_() > (double)0.01f) {
                tailAnimationSpeed = (float)((double)tailAnimationSpeed * 3.5);
            }
            casted.f_32798_ += tailAnimationSpeed;
        }
    }

    @SubscribeEvent
    public static void onPlayerRenderer(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        IGuardianBeamCapability beamCap = Minecraft.m_91087_().f_91074_.getCapability(GuardianBeamCapabilityInstance.GUARDIAN_BEAM_CAP).resolve().orElse(null);
        if (beamCap != null && beamCap.getAttackedEntity().isPresent()) {
            float progression = (float)beamCap.getAttackProgression() + event.getPartialTicks();
            float linearProgression = progression / (float)beamCap.getMaxAttackProgression();
            float progressionSq = linearProgression * linearProgression;
            float animationSpeed = 0.25f;
            float animationMovement = progression * animationSpeed;
            animationMovement *= animationMovement;
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("textures/entity/guardian_beam.png"));
            RenderSystem.m_69478_();
            float scale = 7.0f;
            float r = 0.25f + progressionSq * 0.75f;
            float g = 0.125f + progressionSq * 0.75f;
            float b = 0.5f - progressionSq * 0.25f;
            float a = (float)Math.abs(Math.sin(Math.pow(progression / 2.0f, 1.2f) / 7.0)) * progression / 100.0f;
            RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)a);
            Gui.m_93133_((PoseStack)event.getMatrixStack(), (int)0, (int)0, (float)animationMovement, (float)animationMovement, (int)Minecraft.m_91087_().m_91268_().m_85445_(), (int)Minecraft.m_91087_().m_91268_().m_85446_(), (int)((int)(32.0f * scale)), (int)((int)(32.0f * scale)));
            RenderSystem.m_69461_();
        }
    }
}

