/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.render_handler;

import de.budschie.bmorph.capabilities.phantom_glide.GlideCapabilityInstance;
import de.budschie.bmorph.capabilities.phantom_glide.GlideStatus;
import de.budschie.bmorph.render_handler.IEntitySynchronizerWithRotation;
import de.budschie.bmorph.util.BudschieUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;

public class PhantomSynchronizer
implements IEntitySynchronizerWithRotation {
    @Override
    public boolean appliesToMorph(Entity morphEntity) {
        return morphEntity instanceof Phantom;
    }

    @Override
    public void applyToMorphEntity(Entity morphEntity, Player player) {
    }

    @Override
    public void updateMorphRotation(Entity morphEntity, Player player) {
        Phantom phantom = (Phantom)morphEntity;
        player.getCapability(GlideCapabilityInstance.GLIDE_CAP).ifPresent(cap -> {
            float correctedXRot = -phantom.m_146909_();
            float correctedXRotO = -phantom.f_19860_;
            morphEntity.f_19860_ = morphEntity.m_146909_();
            if (cap.getGlideStatus() == GlideStatus.CHARGE) {
                morphEntity.m_146926_(cap.getChargeDirection().getRotX());
            } else if (cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_IN || cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_OUT) {
                boolean invert = cap.getGlideStatus() == GlideStatus.CHARGE_TRANSITION_OUT;
                float progress = BudschieUtils.getPhantomEaseFunction(cap.getTransitionTime(), cap.getMaxTransitionTime());
                float oldProgress = BudschieUtils.getPhantomEaseFunction(Math.max(cap.getTransitionTime() - 1, 0), cap.getMaxTransitionTime());
                if (invert) {
                    progress = 1.0f - progress;
                    oldProgress = 1.0f - oldProgress;
                }
                progress = Mth.m_14179_((float)Minecraft.m_91087_().m_91297_(), (float)oldProgress, (float)progress);
                morphEntity.m_146926_(Mth.m_14179_((float)progress, (float)cap.getChargeDirection().getRotX(), (float)correctedXRot));
            } else {
                phantom.m_146926_(correctedXRot);
            }
        });
    }
}

