/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.render_handler;

import com.mojang.blaze3d.vertex.PoseStack;
import de.budschie.bmorph.api_interact.ShrinkAPIInteractor;
import de.budschie.bmorph.capabilities.IMorphCapability;
import de.budschie.bmorph.capabilities.MorphCapabilityAttacher;
import de.budschie.bmorph.capabilities.client.render_data.IRenderDataCapability;
import de.budschie.bmorph.capabilities.client.render_data.RenderDataCapabilityProvider;
import de.budschie.bmorph.morph.MorphItem;
import de.budschie.bmorph.morph.player.AdvancedAbstractClientPlayerEntity;
import de.budschie.bmorph.render_handler.IEntitySynchronizer;
import de.budschie.bmorph.render_handler.InitializeMorphEntityEvent;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RenderHandler {
    private static boolean veryDodgyStackOverflowPreventionHackJesJes = false;

    @SubscribeEvent
    public static void onMorphInit(InitializeMorphEntityEvent event) {
        if (event.getPlayer() == Minecraft.m_91087_().f_91074_) {
            event.getMorphEntity().m_20340_(false);
        }
        if (event.getMorphEntity() instanceof AbstractClientPlayer) {
            AbstractClientPlayer entity = (AbstractClientPlayer)event.getMorphEntity();
            entity.m_36163_(event.getPlayer().m_5737_() == HumanoidArm.LEFT ? HumanoidArm.RIGHT : HumanoidArm.LEFT);
        }
        if (event.getMorphEntity() instanceof AdvancedAbstractClientPlayerEntity) {
            AdvancedAbstractClientPlayerEntity advanced = (AdvancedAbstractClientPlayerEntity)event.getMorphEntity();
            advanced.setIsWearing(part -> event.getPlayer().m_36170_(part));
        }
        if (event.getMorphEntity() instanceof Mob) {
            if (event.getMorphEntity() instanceof AbstractSkeleton) {
                ((Mob)event.getMorphEntity()).m_21559_(event.getPlayer().m_5737_() == HumanoidArm.RIGHT);
            } else {
                ((Mob)event.getMorphEntity()).m_21559_(event.getPlayer().m_5737_() == HumanoidArm.LEFT);
            }
        }
    }

    public static void onBuildNewEntity(Player player, IMorphCapability capability, MorphItem aboutToMorphTo) {
        IRenderDataCapability renderDataCapability = (IRenderDataCapability)player.getCapability(RenderDataCapabilityProvider.RENDER_CAP).resolve().get();
        renderDataCapability.invalidateCache();
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRenderedHandler(RenderPlayerEvent.Pre event) {
        if (veryDodgyStackOverflowPreventionHackJesJes) {
            return;
        }
        veryDodgyStackOverflowPreventionHackJesJes = true;
        IRenderDataCapability renderDataCapability = event.getPlayer().getCapability(RenderDataCapabilityProvider.RENDER_CAP).resolve().orElse(null);
        if (renderDataCapability != null) {
            Optional<MorphItem> currentMorph;
            LazyOptional morph = event.getPlayer().getCapability(MorphCapabilityAttacher.MORPH_CAP);
            if (renderDataCapability.hasAnimation()) {
                renderDataCapability.renderAnimation(event.getPlayer(), event.getPoseStack(), event.getPartialTick(), event.getMultiBufferSource(), event.getPackedLight());
                event.setCanceled(true);
            } else if (morph.isPresent() && (currentMorph = ((IMorphCapability)morph.resolve().get()).getCurrentMorph()).isPresent()) {
                event.setCanceled(true);
                Player player = event.getPlayer();
                Entity toRender = renderDataCapability.getOrCreateCachedEntity(player);
                renderDataCapability.getOrCreateCachedRotationSynchronizers(player).forEach(rotationSync -> rotationSync.updateMorphRotation(toRender, player));
                RenderHandler.renderMorph(player, toRender, event.getPoseStack(), event.getPartialTick(), event.getMultiBufferSource(), event.getPackedLight());
            }
        }
        veryDodgyStackOverflowPreventionHackJesJes = false;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IRenderDataCapability renderDataCapability;
        if (event.side == LogicalSide.CLIENT && event.phase == TickEvent.Phase.END && (renderDataCapability = (IRenderDataCapability)event.player.getCapability(RenderDataCapabilityProvider.RENDER_CAP).resolve().orElse(null)) != null) {
            renderDataCapability.tickAnimation();
            ArrayList<IEntitySynchronizer> syncs = renderDataCapability.getOrCreateCachedSynchronizers(event.player);
            if (syncs != null) {
                syncs.forEach(sync -> sync.applyToMorphEntity(renderDataCapability.getOrCreateCachedEntity(event.player), event.player));
            }
        }
    }

    public static void renderMorph(Player player, Entity toRender, PoseStack matrixStack, float partialRenderTicks, MultiBufferSource buffers, int light) {
        float divisor = ShrinkAPIInteractor.getInteractor().getShrinkingValue(player);
        matrixStack.m_85836_();
        if (ShrinkAPIInteractor.getInteractor().isShrunk(player)) {
            matrixStack.m_85841_(0.81f / divisor, 0.81f / divisor, 0.81f / divisor);
        }
        if (toRender.m_6047_() && ShrinkAPIInteractor.getInteractor().isShrunk(player)) {
            matrixStack.m_85837_(0.0, 1.0, 0.0);
        }
        EntityRenderer manager = Minecraft.m_91087_().m_91290_().m_114382_(toRender);
        manager.m_7392_(toRender, 0.0f, partialRenderTicks, matrixStack, buffers, light);
        matrixStack.m_85849_();
    }
}

