/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.render_handler.animations;

import com.mojang.blaze3d.vertex.PoseStack;
import de.budschie.bmorph.render_handler.IEntitySynchronizer;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractMorphChangeAnimation {
    private Player player;
    private Entity transitionFrom;
    private ArrayList<IEntitySynchronizer> synchronizersFrom;
    private Entity transitionTo;
    private ArrayList<IEntitySynchronizer> synchronizersTo;
    private int ticks;
    private int animationDuration;

    public AbstractMorphChangeAnimation(Player player, Entity transitionFrom, ArrayList<IEntitySynchronizer> synchronizersFrom, Entity transitionTo, ArrayList<IEntitySynchronizer> synchronizersTo, int animationDuration) {
        this.player = player;
        this.transitionFrom = transitionFrom;
        this.transitionTo = transitionTo;
        this.synchronizersFrom = synchronizersFrom;
        this.synchronizersTo = synchronizersTo;
        this.animationDuration = animationDuration;
    }

    public int getTicks() {
        return this.ticks;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public Entity getTransitionFrom() {
        return this.transitionFrom;
    }

    public Entity getTransitionTo() {
        return this.transitionTo;
    }

    public ArrayList<IEntitySynchronizer> getSynchronizersFrom() {
        return this.synchronizersFrom;
    }

    public ArrayList<IEntitySynchronizer> getSynchronizersTo() {
        return this.synchronizersTo;
    }

    public void tick() {
        ++this.ticks;
        this.synchronizersFrom.forEach(oldSync -> oldSync.applyToMorphEntity(this.transitionFrom, this.player));
        this.synchronizersTo.forEach(newSync -> newSync.applyToMorphEntity(this.transitionTo, this.player));
    }

    public abstract void render(PoseStack var1, float var2, MultiBufferSource var3, int var4);

    public float getProgress() {
        return (float)this.ticks / (float)this.animationDuration;
    }

    public float getProgress(float partialTicks) {
        return ((float)this.ticks + partialTicks) / (float)this.animationDuration;
    }
}

