/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.util;

import de.budschie.bmorph.main.ServerSetup;
import de.budschie.bmorph.morph.LazyRegistryWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class BudschieUtils {
    public static int getUniversalTickTime() {
        if (ServerSetup.server == null) {
            AtomicLong atomicLong = new AtomicLong(-1L);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (Minecraft.m_91087_().f_91073_ != null) {
                    atomicLong.set(Minecraft.m_91087_().f_91073_.m_46467_());
                }
            });
            return (int)atomicLong.get();
        }
        return ServerSetup.server.m_129921_();
    }

    public static LootItemCondition[][] resolveConditions(List<List<LazyRegistryWrapper<LootItemCondition>>> unresolved) {
        LootItemCondition[][] lootItemConditions = new LootItemCondition[unresolved.size()][];
        for (int i = 0; i < unresolved.size(); ++i) {
            List<LazyRegistryWrapper<LootItemCondition>> innerList = unresolved.get(i);
            lootItemConditions[i] = new LootItemCondition[innerList.size()];
            for (int j = 0; j < innerList.size(); ++j) {
                LootItemCondition resolved = innerList.get(j).getWrappedType();
                if (resolved == null) {
                    return null;
                }
                lootItemConditions[i][j] = resolved;
            }
        }
        return lootItemConditions;
    }

    public static boolean testPredicates(LootItemCondition[][] conditions, Supplier<LootContext> context) {
        if (conditions == null) {
            return false;
        }
        boolean predicateTrue = true;
        LootItemCondition[][] lootItemConditionArray = conditions;
        int n = lootItemConditionArray.length;
        block0: for (int i = 0; i < n; ++i) {
            LootItemCondition[] innerList;
            for (LootItemCondition innerIteration : innerList = lootItemConditionArray[i]) {
                if (innerIteration.test((Object)context.get())) continue block0;
            }
            predicateTrue = false;
            break;
        }
        return predicateTrue;
    }

    public static float getPhantomEaseFunction(float currentTime, float maxTime) {
        return (float)Math.pow(currentTime / maxTime, 1.0);
    }

    public static int convertToRelativeTime(int timestampUntilFinished) {
        return timestampUntilFinished - BudschieUtils.getUniversalTickTime();
    }

    public static int convertToAbsoluteTime(int relativeTime) {
        return relativeTime + BudschieUtils.getUniversalTickTime();
    }

    public static List<ServerPlayer> getPlayersTrackingEntity(ServerPlayer player) {
        ServerChunkCache chunkCache = (ServerChunkCache)player.f_19853_.m_7726_();
        ArrayList<ServerPlayer> serverPlayers = new ArrayList<ServerPlayer>();
        Set trackedPlayers = ((ChunkMap.TrackedEntity)chunkCache.f_8325_.f_140150_.get((int)player.m_142049_())).f_140475_;
        for (ServerPlayerConnection connection : trackedPlayers) {
            serverPlayers.add(connection.m_142253_());
        }
        return serverPlayers;
    }

    public static List<ServerPlayer> getPlayersTrackingEntityAndSelf(ServerPlayer player) {
        List<ServerPlayer> list = BudschieUtils.getPlayersTrackingEntity(player);
        list.add(player);
        return list;
    }
}

