/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.util;

import de.budschie.bmorph.network.MainNetworkChannel;
import de.budschie.bmorph.util.IDynamicRegistryObject;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DynamicRegistry<T extends IDynamicRegistryObject, SP> {
    protected Logger logger = LogManager.getLogger();
    protected HashMap<ResourceLocation, T> entries = new HashMap();

    public void registerEntry(T entry) {
        if (this.entries.containsKey(entry.getResourceLocation())) {
            throw new IllegalArgumentException(String.format("The key %s already exists.", entry.getResourceLocation()));
        }
        this.logger.info("Registered " + entry.getResourceLocation());
        this.entries.put(entry.getResourceLocation(), entry);
        this.onRegister(entry);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public T getEntry(ResourceLocation key) {
        return (T)((IDynamicRegistryObject)this.entries.get(key));
    }

    public Collection<T> values() {
        return this.entries.values();
    }

    public boolean hasEntry(ResourceLocation key) {
        return this.entries.containsKey(key);
    }

    public void unregisterAll() {
        this.entries.forEach((name, entry) -> this.onUnregister(entry));
        this.entries.clear();
    }

    public void onRegister(T registeredObject) {
    }

    public void onUnregister(T unregisteredObject) {
    }

    public abstract SP getPacket();

    public void syncWithClients() {
        if (!this.entries.isEmpty()) {
            MainNetworkChannel.INSTANCE.send(PacketDistributor.ALL.noArg(), this.getPacket());
        }
    }

    public void syncWithClient(ServerPlayer player) {
        if (!this.entries.isEmpty()) {
            MainNetworkChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), this.getPacket());
        }
    }
}

