/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.util;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ParticleCloudInstance {
    public static final Codec<ParticleCloudInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.PARTICLE_TYPE.fieldOf("particle_type").forGetter(ParticleCloudInstance::getParticleType), (App)ModCodecs.VECTOR_3D.optionalFieldOf("offset", (Object)new Vec3(0.0, 0.0, 0.0)).forGetter(ParticleCloudInstance::getOffset), (App)ModCodecs.VECTOR_3D.optionalFieldOf("delta", (Object)new Vec3(1.0, 1.0, 1.0)).forGetter(ParticleCloudInstance::getDelta), (App)Codec.DOUBLE.optionalFieldOf("speed", (Object)1.0).forGetter(ParticleCloudInstance::getSpeed), (App)Codec.INT.optionalFieldOf("count", (Object)100).forGetter(ParticleCloudInstance::getCount)).apply((Applicative)instance, ParticleCloudInstance::new));
    private ParticleType<? extends ParticleOptions> type;
    private Vec3 offset;
    private Vec3 delta;
    private double speed;
    private int count;

    public ParticleCloudInstance(ParticleType<?> type, Vec3 offset, Vec3 delta, double speed, int count) {
        this.type = type;
        this.offset = offset;
        this.delta = delta;
        this.speed = speed;
        this.count = count;
    }

    public ParticleCloudInstance(ParticleType<?> type, double offsetX, double offsetY, double offsetZ, double deltaX, double deltaY, double deltaZ, double speed, int count) {
        this(type, new Vec3(offsetX, offsetY, offsetZ), new Vec3(deltaX, deltaY, deltaZ), speed, count);
    }

    public ParticleType<? extends ParticleOptions> getParticleType() {
        return this.type;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public Vec3 getDelta() {
        return this.delta;
    }

    public double getSpeed() {
        return this.speed;
    }

    public int getCount() {
        return this.count;
    }

    private ParticleOptions getParticleOrThrow() {
        return (ParticleOptions)((Pair)this.type.m_7652_().decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow(false, a -> {})).getFirst();
    }

    public void placeParticleCloudOnClient(Vec3 position) {
        Vec3 finalPos = position.m_82549_(this.offset);
        ClientboundLevelParticlesPacket clpp = new ClientboundLevelParticlesPacket(this.getParticleOrThrow(), false, finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, (float)this.delta.f_82479_, (float)this.delta.f_82480_, (float)this.delta.f_82481_, (float)this.speed, this.count);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91403_().m_7406_(clpp));
    }

    public void placeParticleCloudOnServer(ServerLevel serverLevel, Vec3 position) {
        Vec3 finalPos = position.m_82549_(this.offset);
        serverLevel.m_8767_(this.getParticleOrThrow(), finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_, this.count, this.delta.f_82479_, this.delta.f_82480_, this.delta.f_82481_, this.speed);
    }
}

