/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.budschie.bmorph.morph.functionality.codec_addition.ModCodecs;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class SoundInstance {
    public static final Codec<SoundSource> SOUND_CATEGORY_CODEC = Codec.STRING.flatXmap(str -> DataResult.success((Object)SoundInstance.getSoundSourceByNameOr(str, SoundSource.AMBIENT)), category -> DataResult.success((Object)category.name()));
    public static final Codec<SoundInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModCodecs.SOUND_EVENT_CODEC.fieldOf("sound").forGetter(SoundInstance::getSoundEvent), (App)SOUND_CATEGORY_CODEC.optionalFieldOf("category", (Object)SoundSource.AMBIENT).forGetter(SoundInstance::getSoundCategory), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(SoundInstance::getPitch), (App)Codec.FLOAT.optionalFieldOf("random_pitch_delta", (Object)Float.valueOf(0.125f)).forGetter(SoundInstance::getRandomPitchDelta), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(SoundInstance::getVolume)).apply((Applicative)instance, SoundInstance::new));
    private SoundEvent soundEvent;
    private SoundSource soundCategory;
    private float pitch;
    private float randomPitchDelta;
    private float volume;

    private static SoundSource getSoundSourceByNameOr(String name, SoundSource defaultSound) {
        SoundSource returned = SoundSource.valueOf((String)name);
        return returned == null ? defaultSound : returned;
    }

    public SoundInstance(SoundEvent soundEvent, SoundSource soundCategory, float pitch, float randomPitchDelta, float volume) {
        this.soundEvent = soundEvent;
        this.soundCategory = soundCategory;
        this.pitch = pitch;
        this.randomPitchDelta = randomPitchDelta;
        this.volume = volume;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public SoundSource getSoundCategory() {
        return this.soundCategory;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRandomPitchDelta() {
        return this.randomPitchDelta;
    }

    public float getVolume() {
        return this.volume;
    }

    public void playSoundAt(Entity player) {
        this.playSound(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.f_19853_);
    }

    public void playSound(double x, double y, double z, Level world) {
        world.m_6263_(null, x, y, z, this.soundEvent, this.soundCategory, this.volume, this.getRandomPitch(world));
    }

    private float getRandomPitch(Level world) {
        return (float)(((double)world.m_5822_().nextFloat() - 0.5) * 2.0 * (double)this.randomPitchDelta + (double)this.pitch);
    }
}

