/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class WeightedEntry<T> {
    private T data;
    private int weight;

    public WeightedEntry(int weight, T data) {
        if (weight < 0) {
            throw new IllegalArgumentException(String.format("The weight may not be smaller then 0, but it is: %s.", weight));
        }
        this.data = data;
        this.weight = weight;
    }

    public T getData() {
        return this.data;
    }

    public int getWeight() {
        return this.weight;
    }

    public static <C> Codec<WeightedEntry<C>> codecOf(Codec<C> tCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(WeightedEntry::getWeight), (App)tCodec.fieldOf("data").forGetter(WeightedEntry::getData)).apply((Applicative)instance, WeightedEntry::new));
    }
}

