/*
 * Decompiled with CFR 0.152.
 */
package de.budschie.bmorph.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import de.budschie.bmorph.util.WeightedEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedList<T> {
    private List<WeightedEntry<T>> weights = new ArrayList<WeightedEntry<T>>();
    private int accumulated;

    public WeightedList(List<WeightedEntry<T>> entries) {
        entries.forEach(weight -> {
            this.accumulated += weight.getWeight();
            this.weights.add((WeightedEntry<T>)weight);
        });
        this.weights.sort((o1, o2) -> Integer.compare(o2.getWeight(), o1.getWeight()));
    }

    public T getRandom(Random rand) {
        int toAchieve = rand.nextInt(this.accumulated);
        int currentB = 0;
        for (int i = 0; i < this.weights.size(); ++i) {
            WeightedEntry<T> currentWeight = this.weights.get(i);
            if ((currentB += currentWeight.getWeight()) <= toAchieve) continue;
            return currentWeight.getData();
        }
        throw new IllegalArgumentException("Alright this should not happen. There was an error getting the random thingy to work. Please report this to the mod author immediately.");
    }

    public static <T> Codec<WeightedList<T>> codecOf(Codec<T> codec) {
        return WeightedEntry.codecOf(codec).listOf().flatXmap(convertToList -> DataResult.success(new WeightedList(convertToList)), convertFrom -> DataResult.success(convertFrom.weights));
    }
}

