/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting.recipe;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.ironjetpacks.init.ModRecipeSerializers;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class JetpackUpgradeRecipe
extends ShapedRecipe {
    public JetpackUpgradeRecipe(ResourceLocation id, String group, int recipeWidth, int recipeHeight, NonNullList<Ingredient> inputs, ItemStack output) {
        super(id, group, recipeWidth, recipeHeight, inputs, output);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        CompoundTag tag;
        ItemStack stack = inv.m_8020_(4);
        ItemStack result = this.m_8043_().m_41777_();
        if (!stack.m_41619_() && stack.m_41720_() instanceof JetpackItem && (tag = stack.m_41783_()) != null) {
            String jetpack = NBTHelper.getString((ItemStack)result, (String)"Id");
            tag = tag.m_6426_();
            tag.m_128359_("Id", jetpack);
            result.m_41751_(tag);
            return result;
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.CRAFTING_JETPACK_UPGRADE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<JetpackUpgradeRecipe> {
        public JetpackUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json);
            return new JetpackUpgradeRecipe(recipeId, recipe.m_6076_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_());
        }

        public JetpackUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int k = 0; k < inputs.size(); ++k) {
                inputs.set(k, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new JetpackUpgradeRecipe(recipeId, group, width, height, (NonNullList<Ingredient>)inputs, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, JetpackUpgradeRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130130_(recipe.getRecipeWidth());
            buffer.m_130130_(recipe.getRecipeHeight());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_());
        }
    }
}

