/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.registry;

import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class Jetpack {
    private static final UUID ATTRIBUTE_ID = UUID.fromString("7FBA2C56-DD5E-4071-8519-D2643E707E40");
    public static final Jetpack UNDEFINED = new Jetpack("undefined", 0, 4095, 0, 0, "null", 0.0f, 0.0f);
    private final ResourceLocation id;
    public String name;
    public String displayName;
    public int tier;
    public int color;
    public int armorPoints;
    public int enchantablilty;
    public String craftingMaterialString;
    private Ingredient craftingMaterial;
    public JetpackItem item;
    public boolean creative = false;
    public boolean disabled = false;
    public Rarity rarity = Rarity.COMMON;
    public float toughness;
    public float knockbackResistance;
    public Multimap<Attribute, AttributeModifier> attributeModifiers;
    public int capacity;
    public int usage;
    public double speedVert;
    public double accelVert;
    public double speedSide;
    public double speedHoverAscend;
    public double speedHoverDescend;
    public double speedHoverSlow;
    public double sprintSpeed;
    public double sprintSpeedVert;
    public double sprintFuel;

    public Jetpack(String name, int tier, int color, int armorPoints, int enchantability, String craftingMaterialString, float toughness, float knockbackResistance) {
        this.id = new ResourceLocation("ironjetpacks", name);
        this.name = name;
        this.displayName = this.makeDisplayName();
        this.tier = tier;
        this.color = color;
        this.armorPoints = armorPoints;
        this.enchantablilty = enchantability;
        this.craftingMaterialString = craftingMaterialString;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.attributeModifiers = this.createAttributeModifiers();
    }

    public void setStats(int capacity, int usage, double speedVert, double accelVert, double speedSide, double speedHoverAscend, double speedHoverDescend, double speedHoverSlow, double sprintSpeed, double sprintSpeedVert, double sprintFuel) {
        this.capacity = capacity;
        this.usage = usage;
        this.speedVert = speedVert;
        this.accelVert = accelVert;
        this.speedSide = speedSide;
        this.speedHoverAscend = speedHoverAscend;
        this.speedHoverDescend = speedHoverDescend;
        this.speedHoverSlow = speedHoverSlow;
        this.sprintSpeed = sprintSpeed;
        this.sprintSpeedVert = sprintSpeedVert;
        this.sprintFuel = sprintFuel;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Jetpack setCreative() {
        this.creative = true;
        this.tier = -1;
        this.rarity = Rarity.EPIC;
        return this;
    }

    public Jetpack setCreative(boolean set) {
        if (set) {
            this.setCreative();
        }
        return this;
    }

    public Jetpack setDisabled() {
        this.disabled = true;
        return this;
    }

    public Jetpack setDisabled(boolean set) {
        if (set) {
            this.setDisabled();
        }
        return this;
    }

    public Jetpack setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public int getTier() {
        return this.tier;
    }

    public Ingredient getCraftingMaterial() {
        if (this.craftingMaterial == null) {
            this.craftingMaterial = Ingredient.f_43901_;
            if (!this.craftingMaterialString.equalsIgnoreCase("null")) {
                Item item;
                String[] parts = this.craftingMaterialString.split(":");
                if (parts.length >= 3 && this.craftingMaterialString.startsWith("tag:")) {
                    TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(parts[1], parts[2]));
                    this.craftingMaterial = Ingredient.m_204132_((TagKey)tag);
                } else if (parts.length >= 2 && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null) {
                    this.craftingMaterial = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
                }
            }
        }
        return this.craftingMaterial;
    }

    private String makeDisplayName() {
        String[] parts = this.name.replaceAll(" ", "_").split("_");
        return Arrays.stream(parts).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    private ImmutableMultimap<Attribute, AttributeModifier> createAttributeModifiers() {
        ImmutableMultimap.Builder modifiers = ImmutableMultimap.builder();
        modifiers.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ATTRIBUTE_ID, "Armor modifier", (double)this.armorPoints, AttributeModifier.Operation.ADDITION));
        modifiers.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(ATTRIBUTE_ID, "Armor toughness", (double)this.toughness, AttributeModifier.Operation.ADDITION));
        if (this.knockbackResistance > 0.0f) {
            modifiers.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(ATTRIBUTE_ID, "Armor knockback resistance", (double)this.knockbackResistance, AttributeModifier.Operation.ADDITION));
        }
        return modifiers.build();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("disable", Boolean.valueOf(this.disabled));
        json.addProperty("tier", (Number)this.tier);
        json.addProperty("color", Integer.toHexString(this.color));
        json.addProperty("armorPoints", (Number)this.armorPoints);
        json.addProperty("enchantability", (Number)this.enchantablilty);
        json.addProperty("craftingMaterial", this.craftingMaterialString);
        json.addProperty("creative", Boolean.valueOf(this.creative));
        json.addProperty("rarity", (Number)this.rarity.ordinal());
        json.addProperty("toughness", (Number)Float.valueOf(this.toughness));
        json.addProperty("knockbackResistance", (Number)Float.valueOf(this.knockbackResistance));
        json.addProperty("capacity", (Number)this.capacity);
        json.addProperty("usage", (Number)this.usage);
        json.addProperty("speedVertical", (Number)this.speedVert);
        json.addProperty("accelVertical", (Number)this.accelVert);
        json.addProperty("speedSideways", (Number)this.speedSide);
        json.addProperty("speedHoverAscend", (Number)this.speedHoverAscend);
        json.addProperty("speedHoverDescend", (Number)this.speedHoverDescend);
        json.addProperty("speedHover", (Number)this.speedHoverSlow);
        json.addProperty("sprintSpeedMulti", (Number)this.sprintSpeed);
        json.addProperty("sprintSpeedMultiVertical", (Number)this.sprintSpeedVert);
        json.addProperty("sprintFuelMulti", (Number)this.sprintFuel);
        return json;
    }

    public static Jetpack fromJson(JsonObject json) {
        String name = json.get("name").getAsString();
        boolean disable = json.get("disable").getAsBoolean();
        int tier = json.get("tier").getAsInt();
        int color = Integer.parseInt(json.get("color").getAsString(), 16);
        int armorPoints = json.get("armorPoints").getAsInt();
        int enchantability = json.get("enchantability").getAsInt();
        String craftingMaterialString = json.get("craftingMaterial").getAsString();
        boolean creative = json.get("creative").getAsBoolean();
        Rarity rarity = Rarity.values()[json.get("rarity").getAsInt()];
        float toughness = json.get("toughness").getAsFloat();
        float knockbackResistance = json.get("knockbackResistance").getAsFloat();
        Jetpack jetpack = new Jetpack(name, tier, color, armorPoints, enchantability, craftingMaterialString, toughness, knockbackResistance).setRarity(rarity).setCreative(creative).setDisabled(disable);
        int capacity = json.get("capacity").getAsInt();
        int usage = json.get("usage").getAsInt();
        double speedVert = json.get("speedVertical").getAsDouble();
        double accelVert = json.get("accelVertical").getAsDouble();
        double speedSide = json.get("speedSideways").getAsDouble();
        double speedHoverAscend = json.get("speedHoverAscend").getAsDouble();
        double speedHoverDescend = json.get("speedHoverDescend").getAsDouble();
        double speedHoverSlow = json.get("speedHover").getAsDouble();
        double sprintSpeed = json.get("sprintSpeedMulti").getAsDouble();
        double sprintSpeedVert = json.get("sprintSpeedMultiVertical").getAsDouble();
        double sprintFuel = json.get("sprintFuelMulti").getAsDouble();
        jetpack.setStats(capacity, usage, speedVert, accelVert, speedSide, speedHoverAscend, speedHoverDescend, speedHoverSlow, sprintSpeed, sprintSpeedVert, sprintFuel);
        return jetpack;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.writeBoolean(this.disabled);
        buffer.m_130130_(this.tier);
        buffer.m_130130_(this.color);
        buffer.m_130130_(this.armorPoints);
        buffer.m_130130_(this.enchantablilty);
        buffer.m_130070_(this.craftingMaterialString);
        buffer.writeBoolean(this.creative);
        buffer.m_130130_(this.rarity.ordinal());
        buffer.writeFloat(this.toughness);
        buffer.writeFloat(this.knockbackResistance);
        buffer.m_130130_(this.capacity);
        buffer.m_130130_(this.usage);
        buffer.writeDouble(this.speedVert);
        buffer.writeDouble(this.accelVert);
        buffer.writeDouble(this.speedSide);
        buffer.writeDouble(this.speedHoverAscend);
        buffer.writeDouble(this.speedHoverDescend);
        buffer.writeDouble(this.speedHoverSlow);
        buffer.writeDouble(this.sprintSpeed);
        buffer.writeDouble(this.sprintSpeedVert);
        buffer.writeDouble(this.sprintFuel);
    }

    public static Jetpack read(FriendlyByteBuf buffer) {
        String name = buffer.m_130277_();
        boolean disabled = buffer.readBoolean();
        int tier = buffer.m_130242_();
        int color = buffer.m_130242_();
        int armorPoints = buffer.m_130242_();
        int enchantability = buffer.m_130242_();
        String craftingMaterialString = buffer.m_130277_();
        boolean creative = buffer.readBoolean();
        Rarity rarity = Rarity.values()[buffer.m_130242_()];
        float toughness = buffer.readFloat();
        float knockbackResistance = buffer.readFloat();
        Jetpack jetpack = new Jetpack(name, tier, color, armorPoints, enchantability, craftingMaterialString, toughness, knockbackResistance).setRarity(rarity).setCreative(creative).setDisabled(disabled);
        int capacity = buffer.m_130242_();
        int usage = buffer.m_130242_();
        double speedVert = buffer.readDouble();
        double accelVert = buffer.readDouble();
        double speedSide = buffer.readDouble();
        double speedHoverAscend = buffer.readDouble();
        double speedHoverDescend = buffer.readDouble();
        double speedHoverSlow = buffer.readDouble();
        double sprintSpeed = buffer.readDouble();
        double sprintSpeedVert = buffer.readDouble();
        double sprintFuel = buffer.readDouble();
        jetpack.setStats(capacity, usage, speedVert, accelVert, speedSide, speedHoverAscend, speedHoverDescend, speedHoverSlow, sprintSpeed, sprintSpeedVert, sprintFuel);
        return jetpack;
    }
}

