/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.multiblock.part.io.power.charging;

import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.AbstractPowerPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.charging.IChargingPortHandler;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.item.inventory.handler.TileEntityItemStackHandler;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractChargingPortHandler<Controller extends AbstractCuboidMultiblockController<Controller>, T extends AbstractMultiblockEntity<Controller>>
extends AbstractPowerPortHandler<Controller, T>
implements IChargingPortHandler,
ISyncableEntity {
    private final ItemStackHandler _input;
    private final ItemStackHandler _output;
    private WideAmount _chargingRate;

    protected AbstractChargingPortHandler(EnergySystem energySystem, T part, int inputSlotsCount, int outputSlotsCount) {
        super(energySystem, part, IoMode.Active);
        this._input = new TileEntityItemStackHandler((BlockEntity)part, inputSlotsCount);
        this._output = new TileEntityItemStackHandler((BlockEntity)part, outputSlotsCount);
        this._chargingRate = WideAmount.ZERO;
    }

    protected WideAmount getChargingRate() {
        if (this._chargingRate.isZero()) {
            this._chargingRate = ((IPowerPort)this.getPart()).getMaxTransferRate();
        }
        return this._chargingRate;
    }

    protected <C> LazyOptional<C> getCapabilityFromInventory(Capability<C> capability, int inputSlotIndex, boolean ejectIfNotFound) {
        ItemStack stack = this._input.getStackInSlot(inputSlotIndex);
        if (!stack.m_41619_()) {
            LazyOptional cap = stack.getCapability(capability, null);
            if (ejectIfNotFound && !cap.isPresent()) {
                this.eject(inputSlotIndex);
            }
            return cap;
        }
        return LazyOptional.empty();
    }

    protected void eject(int inputSlotIndex) {
        ItemStack input = this._input.getStackInSlot(inputSlotIndex);
        if (!input.m_41619_()) {
            for (int idx = 0; idx < this.getOutputSlotsCount(); ++idx) {
                if (!this._output.getStackInSlot(idx).m_41619_()) continue;
                this._output.setStackInSlot(idx, input);
                this._input.setStackInSlot(inputSlotIndex, ItemStack.f_41583_);
                return;
            }
        }
    }

    protected int getInputSlotsCount() {
        return this._input.getSlots();
    }

    protected int getOutputSlotsCount() {
        return this._input.getSlots();
    }

    @Override
    public IItemHandlerModifiable getItemStackHandler(IoDirection direction) {
        return direction.isInput() ? this._input : this._output;
    }

    @Override
    public void eject() {
        for (int idx = 0; idx <= this.getInputSlotsCount(); ++idx) {
            this.eject(idx);
        }
    }

    @Override
    public boolean isConnected() {
        for (int idx = 0; idx <= this.getInputSlotsCount(); ++idx) {
            if (this._input.getStackInSlot(idx).m_41619_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkConnections(@Nullable Level world, BlockPos position) {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void syncDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvFrom(data, "in", this._input);
            AbstractChargingPortHandler.syncInvFrom(data, "out", this._output);
        }
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            AbstractChargingPortHandler.syncInvTo(data, "in", this._input);
            AbstractChargingPortHandler.syncInvTo(data, "out", this._output);
        }
        return data;
    }

    private static void syncInvTo(CompoundTag data, String name, ItemStackHandler inv) {
        data.m_128365_(name, (Tag)inv.serializeNBT());
    }

    private static void syncInvFrom(CompoundTag data, String name, ItemStackHandler inv) {
        if (data.m_128441_(name)) {
            inv.deserializeNBT(data.m_128469_(name));
        }
    }
}

