/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.internal.network.Network;
import it.zerono.mods.zerocore.internal.network.TileCommandMessage;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.IBlockStateUpdater;
import it.zerono.mods.zerocore.lib.block.ITileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.IVersionAwareSyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractModBlockEntity
extends BlockEntity
implements IBlockStateUpdater,
ISyncableEntity,
IDebuggable {
    @Deprecated
    public final IEvent<Runnable> DataUpdate;
    private static final int EVENT_CLIENT_RENDER_UPDATE = 1;
    private ITileCommandDispatcher _commandDispatcher = (source, name, parameters) -> {};

    public AbstractModBlockEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
        this.DataUpdate = new Event<Runnable>();
    }

    public Block getBlockType() {
        return this.m_58900_().m_60734_();
    }

    public void callOnLogicalSide(Runnable serverCode, Runnable clientCode) {
        if (null != this.f_58857_) {
            CodeHelper.callOnLogicalSide(this.f_58857_, serverCode, clientCode);
        }
    }

    public <T> T callOnLogicalSide(Supplier<T> serverCode, Supplier<T> clientCode, Supplier<T> invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalSide(this.f_58857_, serverCode, clientCode);
    }

    public boolean callOnLogicalSide(BooleanSupplier serverCode, BooleanSupplier clientCode) {
        return null != this.f_58857_ && CodeHelper.callOnLogicalSide(this.f_58857_, serverCode, clientCode);
    }

    public int callOnLogicalSide(IntSupplier serverCode, IntSupplier clientCode, IntSupplier invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue.getAsInt();
        }
        return CodeHelper.callOnLogicalSide(this.f_58857_, serverCode, clientCode);
    }

    public long callOnLogicalSide(LongSupplier serverCode, LongSupplier clientCode, LongSupplier invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue.getAsLong();
        }
        return CodeHelper.callOnLogicalSide(this.f_58857_, serverCode, clientCode);
    }

    public double callOnLogicalSide(DoubleSupplier serverCode, DoubleSupplier clientCode, DoubleSupplier invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue.getAsDouble();
        }
        return CodeHelper.callOnLogicalSide(this.f_58857_, serverCode, clientCode);
    }

    public void callOnLogicalServer(Runnable code) {
        if (null != this.f_58857_) {
            CodeHelper.callOnLogicalServer(this.f_58857_, code);
        }
    }

    public void callOnLogicalServer(Consumer<Level> code) {
        if (null != this.f_58857_ && CodeHelper.calledByLogicalServer(this.f_58857_)) {
            code.accept(this.f_58857_);
        }
    }

    public <T> T callOnLogicalServer(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalServer(this.f_58857_, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalServer(BooleanSupplier code) {
        return null != this.f_58857_ && CodeHelper.callOnLogicalServer(this.f_58857_, code);
    }

    public int callOnLogicalServer(IntSupplier code, int invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.f_58857_, code, invalidSideReturnValue);
    }

    public long callOnLogicalServer(LongSupplier code, long invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.f_58857_, code, invalidSideReturnValue);
    }

    public double callOnLogicalServer(DoubleSupplier code, double invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalServer(this.f_58857_, code, invalidSideReturnValue);
    }

    public void callOnLogicalClient(Runnable code) {
        if (null != this.f_58857_) {
            CodeHelper.callOnLogicalClient(this.f_58857_, code);
        }
    }

    public void callOnLogicalClient(Consumer<Level> code) {
        if (null != this.f_58857_ && CodeHelper.calledByLogicalClient(this.f_58857_)) {
            code.accept(this.f_58857_);
        }
    }

    public <T> T callOnLogicalClient(Supplier<T> code, Supplier<T> invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue.get();
        }
        return CodeHelper.callOnLogicalClient(this.f_58857_, code, invalidSideReturnValue);
    }

    public boolean callOnLogicalClient(BooleanSupplier code) {
        return null != this.f_58857_ && CodeHelper.callOnLogicalClient(this.f_58857_, code);
    }

    public int callOnLogicalClient(IntSupplier code, int invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.f_58857_, code, invalidSideReturnValue);
    }

    public long callOnLogicalClient(LongSupplier code, long invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.f_58857_, code, invalidSideReturnValue);
    }

    public double callOnLogicalClient(DoubleSupplier code, double invalidSideReturnValue) {
        if (null == this.f_58857_) {
            return invalidSideReturnValue;
        }
        return CodeHelper.callOnLogicalClient(this.f_58857_, code, invalidSideReturnValue);
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return false;
    }

    public boolean openGui(ServerPlayer player) {
        return this.openGuiOnClient(player, buffer -> {});
    }

    public boolean openGui(ServerPlayer player, Consumer<FriendlyByteBuf> extraDataWriter) {
        return this.openGuiOnClient(player, extraDataWriter);
    }

    public static <T extends AbstractModBlockEntity> T getGuiClientBlockEntity(FriendlyByteBuf networkData) {
        return (T)((AbstractModBlockEntity)WorldHelper.getClientTile(networkData.m_130135_()).orElseThrow(NullPointerException::new));
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.syncEntityDataFrom(data, ISyncableEntity.SyncReason.FullSync);
    }

    protected void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.syncEntityDataTo(data, ISyncableEntity.SyncReason.FullSync);
    }

    public void handleUpdateTag(CompoundTag data) {
        super.m_142466_(data);
        this.syncEntityDataFrom(data, ISyncableEntity.SyncReason.NetworkUpdate);
    }

    public CompoundTag m_5995_() {
        return this.syncEntityDataTo(super.m_5995_(), ISyncableEntity.SyncReason.NetworkUpdate);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.syncEntityDataFrom(packet.m_131708_(), ISyncableEntity.SyncReason.NetworkUpdate);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void onDataUpdate() {
        this.DataUpdate.raise(Runnable::run);
    }

    private void syncEntityDataFrom(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        CompoundTag dataToSync = data;
        if (syncReason.isFullSync() && data.m_128441_("zcvase_version") && data.m_128441_("zcvase_payload")) {
            CompoundTag payload = dataToSync = data.m_128469_("zcvase_payload");
            if (this instanceof IVersionAwareSyncableEntity) {
                IVersionAwareSyncableEntity vase = (IVersionAwareSyncableEntity)((Object)this);
                int dataVersion = data.m_128451_("zcvase_version");
                if (vase.syncGetDataCurrentVersion() > dataVersion) {
                    dataToSync = vase.syncGetVersionConverter(dataVersion).apply(payload);
                }
            }
        }
        this.syncDataFrom(dataToSync, syncReason);
        this.onDataUpdate();
    }

    private CompoundTag syncEntityDataTo(CompoundTag data, ISyncableEntity.SyncReason syncReason) {
        if (syncReason.isFullSync()) {
            data.m_128405_("zcvase_version", this.syncGetEntityDataCurrentVersion());
            data.m_128365_("zcvase_payload", (Tag)this.syncDataTo(new CompoundTag(), syncReason));
            return data;
        }
        return this.syncDataTo(data, syncReason);
    }

    private int syncGetEntityDataCurrentVersion() {
        return this instanceof IVersionAwareSyncableEntity ? ((IVersionAwareSyncableEntity)((Object)this)).syncGetDataCurrentVersion() : -1;
    }

    public void sendCommandToServer(String name) {
        this.sendCommandToServer(name, NBTHelper.EMPTY_COMPOUND);
    }

    public void sendCommandToServer(String name, CompoundTag parameters) {
        Network.HANDLER.sendToServer(TileCommandMessage.create(this, name, parameters));
    }

    public void sendCommandToPlayer(ServerPlayer player, String name) {
        this.sendCommandToPlayer(player, name, NBTHelper.EMPTY_COMPOUND);
    }

    public void sendCommandToPlayer(ServerPlayer player, String name, CompoundTag parameters) {
        Network.HANDLER.sendToPlayer(TileCommandMessage.create(this, name, parameters), player);
    }

    public void handleCommand(LogicalSide source, String name, CompoundTag parameters) {
        this._commandDispatcher.dispatch(source, name, parameters);
    }

    protected void setCommandDispatcher(ITileCommandDispatcher dispatcher) {
        this._commandDispatcher = Objects.requireNonNull(dispatcher);
    }

    public void markChunkDirty() {
        Level world = this.m_58904_();
        if (null != world) {
            world.m_151543_(this.m_58899_());
        }
    }

    public void callNeighborBlockChange() {
        Level world = this.m_58904_();
        if (null != world) {
            WorldHelper.notifyNeighborsOfStateChange(world, this.m_58899_(), this.m_58900_().m_60734_());
        }
    }

    @Deprecated
    public void callNeighborTileChange() {
    }

    public void notifyBlockUpdate() {
        Level world = this.m_58904_();
        if (null != world) {
            WorldHelper.notifyBlockUpdate(world, this.m_58899_(), null, null);
        }
    }

    public void notifyBlockUpdate(BlockState oldState, BlockState newState) {
        Level world = this.m_58904_();
        if (null != world) {
            WorldHelper.notifyBlockUpdate(world, this.m_58899_(), oldState, newState);
        }
    }

    public static <T extends AbstractModBlockEntity> void notifyBlockUpdate(Collection<T> entities) {
        entities.forEach(AbstractModBlockEntity::notifyBlockUpdate);
    }

    public static <T extends AbstractModBlockEntity> void notifyBlockUpdate(Stream<T> entities) {
        entities.forEach(AbstractModBlockEntity::notifyBlockUpdate);
    }

    public void notifyTileEntityUpdate() {
        Level world = this.m_58904_();
        if (null != world) {
            this.m_6596_();
            WorldHelper.notifyBlockUpdate(world, this.m_58899_(), null, null);
        }
    }

    public void markForRenderUpdate() {
        WorldHelper.markBlockRangeForRenderUpdate(this.m_58899_(), this.m_58899_());
    }

    public void requestClientRenderUpdate() {
        if (null != this.f_58857_) {
            this.f_58857_.m_7696_(this.m_58899_(), this.getBlockType(), 1, 0);
        }
    }

    public boolean m_7531_(int id, int type) {
        if (null != this.f_58857_) {
            switch (id) {
                case 1: {
                    this.callOnLogicalClient(this::markForRenderUpdate);
                    return true;
                }
            }
        }
        return super.m_7531_(id, type);
    }

    @Override
    public void updateBlockState(BlockState currentState, LevelAccessor world, BlockPos position, @Nullable BlockEntity tileEntity, int updateFlags) {
        Block block = currentState.m_60734_();
        if (block instanceof IBlockStateUpdater) {
            ((IBlockStateUpdater)block).updateBlockState(currentState, world, position, tileEntity, updateFlags);
        } else {
            world.m_7731_(position, this.buildUpdatedState(currentState, (BlockGetter)world, position, tileEntity), updateFlags);
        }
    }

    @Override
    @Nonnull
    public BlockState buildUpdatedState(BlockState currentState, BlockGetter reader, BlockPos position, @Nullable BlockEntity tileEntity) {
        return currentState;
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        messages.addUnlocalized("Tile Entity class: %1$s", this.getClass().getSimpleName());
    }

    private boolean openGuiOnClient(ServerPlayer player, Consumer<FriendlyByteBuf> extraDataWriter) {
        return this.callOnLogicalServer(() -> {
            if (this instanceof MenuProvider && !(player instanceof FakePlayer)) {
                Consumer<FriendlyByteBuf> positionWriter = buffer -> buffer.m_130064_(this.m_58899_());
                NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)((MenuProvider)this), positionWriter.andThen(extraDataWriter));
                return true;
            }
            return false;
        });
    }
}

