/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.model;

import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.Flags;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractDynamicBakedModel
implements IDynamicBakedModel {
    private final Flags<SupportFlags> _flags = new Flags<SupportFlags>(SupportFlags.class);

    protected AbstractDynamicBakedModel(boolean ambientOcclusion, boolean guid3D) {
        this(ambientOcclusion, guid3D, false);
    }

    protected AbstractDynamicBakedModel(boolean ambientOcclusion, boolean guid3D, boolean builtInRenderer) {
        this._flags.addIf(SupportFlags.AmbientOcclusion, ambientOcclusion);
        this._flags.addIf(SupportFlags.Gui3D, guid3D);
        this._flags.addIf(SupportFlags.BuiltInRenderer, builtInRenderer);
    }

    protected BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, Vector3d normal, ISprite sprite, Colour colour, int tintIndex, short lightMapU, short lightMapV) {
        BakedQuadBuilder builder = AbstractDynamicBakedModel.builder(sprite, normal, tintIndex);
        this.createVertex(builder, v1.X, v1.Y, v1.Z, normal, 16.0f, 16.0f, sprite, colour, lightMapU, lightMapV);
        this.createVertex(builder, v2.X, v2.Y, v2.Z, normal, 0.0f, 16.0f, sprite, colour, lightMapU, lightMapV);
        this.createVertex(builder, v3.X, v3.Y, v3.Z, normal, 0.0f, 0.0f, sprite, colour, lightMapU, lightMapV);
        this.createVertex(builder, v4.X, v4.Y, v4.Z, normal, 16.0f, 0.0f, sprite, colour, lightMapU, lightMapV);
        return builder.build();
    }

    protected BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, ISprite sprite, Colour colour) {
        return this.createQuad(v1, v2, v3, v4, AbstractDynamicBakedModel.normal(v1, v2, v3, v4), sprite, colour, 0, (short)0, (short)0);
    }

    protected BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, ISprite sprite) {
        return this.createQuad(v1, v2, v3, v4, sprite, Colour.WHITE);
    }

    protected BakedQuad createQuadReversed(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, ISprite sprite, Colour colour, int tintIndex, short lightMapU, short lightMapV) {
        return this.createQuad(v1, v2, v3, v4, AbstractDynamicBakedModel.reversedNormal(v1, v2, v3, v4), sprite, colour, tintIndex, lightMapU, lightMapV);
    }

    protected BakedQuad createQuadReversed(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, ISprite sprite) {
        return this.createQuad(v1, v2, v3, v4, AbstractDynamicBakedModel.reversedNormal(v1, v2, v3, v4), sprite, Colour.WHITE, 0, (short)0, (short)0);
    }

    protected BakedQuad createFace(Direction face, float width, float height, float depth, ISprite sprite) {
        return this.createFace(face, width, height, depth, sprite, Colour.WHITE, 0, (short)0, (short)0, Vector3d.ZERO);
    }

    protected BakedQuad createFace(Direction face, float width, float height, float depth, ISprite sprite, int tintIndex, Vector3d offset) {
        return this.createFace(face, width, height, depth, sprite, Colour.WHITE, tintIndex, (short)0, (short)0, offset);
    }

    protected BakedQuad createFace(Direction face, float width, float height, float depth, ISprite sprite, Colour colour, int tintIndex, short lightMapU, short lightMapV, Vector3d offset) {
        Vector3d[] vertices = ModRenderHelper.getQuadVerticesFor(face, width, height, depth, offset);
        return this.createQuad(vertices[0], vertices[1], vertices[2], vertices[3], AbstractDynamicBakedModel.normal(face), sprite, colour, tintIndex, lightMapU, lightMapV);
    }

    protected void createVertex(BakedQuadBuilder builder, double x, double y, double z, Vector3d normal, float u, float v, ISprite sprite, Colour colour, short lightMapU, short lightMapV) {
        int elementIndex = 0;
        for (VertexFormatElement element : builder.getVertexFormat().m_86023_()) {
            block0 : switch (element.m_86048_()) {
                case POSITION: {
                    builder.put(elementIndex, new float[]{(float)x, (float)y, (float)z});
                    break;
                }
                case COLOR: {
                    builder.put(elementIndex, new float[]{colour.R, colour.G, colour.B, colour.A});
                    break;
                }
                case UV: {
                    switch (element.m_86049_()) {
                        case 0: {
                            builder.put(elementIndex, new float[]{sprite.getInterpolatedU(u), sprite.getInterpolatedV(v)});
                            break block0;
                        }
                        case 2: {
                            builder.put(elementIndex, new float[]{lightMapU, lightMapV});
                            break block0;
                        }
                    }
                    builder.put(elementIndex, new float[0]);
                    break;
                }
                case NORMAL: {
                    builder.put(elementIndex, new float[]{(float)normal.X, (float)normal.Y, (float)normal.Z});
                    break;
                }
                default: {
                    builder.put(elementIndex, new float[0]);
                }
            }
            ++elementIndex;
        }
    }

    public boolean m_7541_() {
        return this._flags.contains(SupportFlags.AmbientOcclusion);
    }

    public boolean m_7539_() {
        return this._flags.contains(SupportFlags.Gui3D);
    }

    public boolean m_7521_() {
        return this._flags.contains(SupportFlags.BuiltInRenderer);
    }

    public boolean m_7547_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return ModRenderHelper.getMissingModel().getParticleIcon((IModelData)EmptyModelData.INSTANCE);
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    protected static BakedQuadBuilder builder(ISprite sprite) {
        return new BakedQuadBuilder(sprite.getAtlasSprite().orElse(ModRenderHelper.getMissingTexture()));
    }

    protected static BakedQuadBuilder builder(ISprite sprite, Vector3d normal, int tintIndex) {
        BakedQuadBuilder builder = AbstractDynamicBakedModel.builder(sprite);
        builder.setQuadOrientation(Direction.m_122366_((double)normal.X, (double)normal.Y, (double)normal.Z));
        builder.setQuadTint(tintIndex);
        return builder;
    }

    private static Vector3d normal(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4) {
        return v3.subtract(v2).crossProduct(v1.subtract(v2)).normalize();
    }

    private static Vector3d reversedNormal(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4) {
        return v3.subtract(v1).crossProduct(v2.subtract(v1)).normalize();
    }

    private static Vector3d normal(Direction direction) {
        return Vector3d.from(direction.m_122436_());
    }

    private static enum SupportFlags {
        AmbientOcclusion,
        Gui3D,
        BuiltInRenderer;

    }
}

