/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import it.zerono.mods.zerocore.lib.energy.EnergyStack;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.WideEnergyStack;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class StackAdapters {
    public static final IStackAdapter<ItemStack, Item> ITEMSTACK = new IStackAdapter<ItemStack, Item>(){

        @Override
        public Optional<Item> getContent(ItemStack stack) {
            return !stack.m_41619_() ? Optional.of(stack.m_41720_()) : Optional.empty();
        }

        @Override
        public int getAmount(ItemStack stack) {
            return stack.m_41613_();
        }

        @Override
        public ItemStack setAmount(ItemStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.m_41764_(amount);
            return stack;
        }

        @Override
        public ItemStack modifyAmount(ItemStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.m_41769_(delta);
            return stack;
        }

        @Override
        public ItemStack getEmptyStack() {
            return ItemStack.f_41583_;
        }

        @Override
        public boolean isEmpty(ItemStack stack) {
            return stack.m_41619_();
        }

        @Override
        public boolean isStackContentEqual(ItemStack stack1, ItemStack stack2) {
            return stack1.m_41656_(stack2);
        }

        @Override
        public boolean isContentEqual(Item content1, Item content2) {
            return content1 == content2;
        }

        @Override
        public boolean areIdentical(ItemStack stack1, ItemStack stack2) {
            return ItemStack.m_41728_((ItemStack)stack1, (ItemStack)stack2);
        }

        @Override
        public ItemStack create(Item content, int amount) {
            return ItemHelper.stackFrom((ItemLike)content, amount);
        }

        @Override
        public ItemStack create(ItemStack stack) {
            return ItemHelper.stackFrom(stack);
        }

        public ItemStack[] createArray(int length) {
            return new ItemStack[length];
        }

        @Override
        public List<ItemStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<ItemStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public ItemStack readFrom(CompoundTag data) {
            return ItemHelper.stackFrom(data);
        }

        @Override
        public CompoundTag writeTo(ItemStack stack, CompoundTag data) {
            return stack.m_41739_(data);
        }

        @Override
        public String toString(ItemStack stack) {
            return stack.toString();
        }

        @Override
        public <T> T map(ItemStack stack, Function<Item, T> mapper, T defaultValue) {
            return stack.m_41619_() ? defaultValue : mapper.apply(stack.m_41720_());
        }

        @Override
        public <T> T map(ItemStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.m_41619_() ? defaultValue : mapper.apply(stack.m_41613_());
        }

        @Override
        public <T> T map(ItemStack stack, BiFunction<Item, Integer, T> mapper, T defaultValue) {
            return stack.m_41619_() ? defaultValue : mapper.apply(stack.m_41720_(), stack.m_41613_());
        }

        @Override
        public void accept(ItemStack stack, Consumer<Item> consumer) {
            if (!stack.m_41619_()) {
                consumer.accept(stack.m_41720_());
            }
        }

        @Override
        public void accept(ItemStack stack, IntConsumer consumer) {
            if (!stack.m_41619_()) {
                consumer.accept(stack.m_41613_());
            }
        }

        @Override
        public void accept(ItemStack stack, BiConsumer<Item, Integer> consumer) {
            if (!stack.m_41619_()) {
                consumer.accept(stack.m_41720_(), stack.m_41613_());
            }
        }
    };
    public static final IStackAdapter<FluidStack, Fluid> FLUIDSTACK = new IStackAdapter<FluidStack, Fluid>(){

        @Override
        public Optional<Fluid> getContent(FluidStack stack) {
            return !stack.isEmpty() ? Optional.ofNullable(stack.getFluid()) : Optional.empty();
        }

        @Override
        public int getAmount(FluidStack stack) {
            return stack.getAmount();
        }

        @Override
        public FluidStack setAmount(FluidStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.setAmount(amount);
            return stack;
        }

        @Override
        public FluidStack modifyAmount(FluidStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.grow(delta);
            return stack;
        }

        @Override
        public FluidStack getEmptyStack() {
            return FluidStack.EMPTY;
        }

        @Override
        public boolean isEmpty(FluidStack stack) {
            return stack.isEmpty();
        }

        @Override
        public boolean isStackContentEqual(FluidStack stack1, FluidStack stack2) {
            return stack1.isFluidEqual(stack2);
        }

        @Override
        public boolean isContentEqual(Fluid content1, Fluid content2) {
            return content1.m_6212_(content2);
        }

        @Override
        public boolean areIdentical(FluidStack stack1, FluidStack stack2) {
            return stack1.isFluidStackIdentical(stack2);
        }

        @Override
        public FluidStack create(Fluid content, int amount) {
            return new FluidStack(content, amount);
        }

        @Override
        public FluidStack create(FluidStack stack) {
            return stack.copy();
        }

        public FluidStack[] createArray(int length) {
            return new FluidStack[length];
        }

        @Override
        public List<FluidStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<FluidStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public FluidStack readFrom(CompoundTag data) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)data);
        }

        @Override
        public CompoundTag writeTo(FluidStack stack, CompoundTag data) {
            return stack.writeToNBT(data);
        }

        @Override
        public String toString(FluidStack stack) {
            return stack.getAmount() + " " + stack.getFluid();
        }

        @Override
        public <T> T map(FluidStack stack, Function<Fluid, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getFluid());
        }

        @Override
        public <T> T map(FluidStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getAmount());
        }

        @Override
        public <T> T map(FluidStack stack, BiFunction<Fluid, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getFluid(), stack.getAmount());
        }

        @Override
        public void accept(FluidStack stack, Consumer<Fluid> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getFluid());
            }
        }

        @Override
        public void accept(FluidStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getAmount());
            }
        }

        @Override
        public void accept(FluidStack stack, BiConsumer<Fluid, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getFluid(), stack.getAmount());
            }
        }
    };
    @Deprecated
    public static final IStackAdapter<EnergyStack, EnergySystem> ENERGYSTACK = new IStackAdapter<EnergyStack, EnergySystem>(){

        @Override
        public Optional<EnergySystem> getContent(EnergyStack stack) {
            return !stack.isEmpty() ? Optional.of(stack.getEnergySystem()) : Optional.empty();
        }

        @Override
        public int getAmount(EnergyStack stack) {
            return (int)stack.getAmount();
        }

        @Override
        public EnergyStack setAmount(EnergyStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.setAmount(amount);
            return stack;
        }

        @Override
        public EnergyStack modifyAmount(EnergyStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.grow(delta);
            return stack;
        }

        @Override
        public EnergyStack getEmptyStack() {
            return EnergyStack.EMPTY;
        }

        @Override
        public boolean isEmpty(EnergyStack stack) {
            return stack.isEmpty();
        }

        @Override
        public boolean isStackContentEqual(EnergyStack stack1, EnergyStack stack2) {
            return stack1.isEnergySystemEqual(stack2);
        }

        @Override
        public boolean isContentEqual(EnergySystem content1, EnergySystem content2) {
            return content1 == content2;
        }

        @Override
        public boolean areIdentical(EnergyStack stack1, EnergyStack stack2) {
            return EnergyStack.areItemStacksEqual(stack1, stack2);
        }

        @Override
        public EnergyStack create(EnergySystem content, int amount) {
            return new EnergyStack(content, amount);
        }

        @Override
        public EnergyStack create(EnergyStack stack) {
            return stack.copy();
        }

        public EnergyStack[] createArray(int length) {
            return new EnergyStack[length];
        }

        @Override
        public List<EnergyStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<EnergyStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public EnergyStack readFrom(CompoundTag data) {
            return EnergyStack.from(data);
        }

        @Override
        public CompoundTag writeTo(EnergyStack stack, CompoundTag data) {
            return stack.serializeTo(data);
        }

        @Override
        public String toString(EnergyStack stack) {
            return stack.toString();
        }

        @Override
        public <T> T map(EnergyStack stack, Function<EnergySystem, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem());
        }

        @Override
        public <T> T map(EnergyStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply((int)stack.getAmount());
        }

        @Override
        public <T> T map(EnergyStack stack, BiFunction<EnergySystem, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem(), (int)stack.getAmount());
        }

        @Override
        public void accept(EnergyStack stack, Consumer<EnergySystem> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem());
            }
        }

        @Override
        public void accept(EnergyStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept((int)stack.getAmount());
            }
        }

        @Override
        public void accept(EnergyStack stack, BiConsumer<EnergySystem, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem(), (int)stack.getAmount());
            }
        }
    };
    public static final IStackAdapter<WideEnergyStack, EnergySystem> WIDEENERGYSTACK = new IStackAdapter<WideEnergyStack, EnergySystem>(){

        @Override
        public Optional<EnergySystem> getContent(WideEnergyStack stack) {
            return !stack.isEmpty() ? Optional.of(stack.getEnergySystem()) : Optional.empty();
        }

        @Override
        public int getAmount(WideEnergyStack stack) {
            return stack.getAmount().intValue();
        }

        @Override
        public WideEnergyStack setAmount(WideEnergyStack stack, int amount) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.setAmount(WideAmount.from(amount));
            return stack;
        }

        @Override
        public WideEnergyStack modifyAmount(WideEnergyStack stack, int delta) {
            StackAdapters.validateNotEmpty(this, stack);
            stack.grow(WideAmount.from(delta));
            return stack;
        }

        @Override
        public WideEnergyStack getEmptyStack() {
            return WideEnergyStack.EMPTY;
        }

        @Override
        public boolean isEmpty(WideEnergyStack stack) {
            return stack.isEmpty();
        }

        @Override
        public boolean isStackContentEqual(WideEnergyStack stack1, WideEnergyStack stack2) {
            return stack1.isEnergySystemEqual(stack2);
        }

        @Override
        public boolean isContentEqual(EnergySystem content1, EnergySystem content2) {
            return content1 == content2;
        }

        @Override
        public boolean areIdentical(WideEnergyStack stack1, WideEnergyStack stack2) {
            return WideEnergyStack.areStacksEqual(stack1, stack2);
        }

        @Override
        public WideEnergyStack create(EnergySystem content, int amount) {
            return new WideEnergyStack(content, WideAmount.from(amount));
        }

        @Override
        public WideEnergyStack create(WideEnergyStack stack) {
            return stack.copy();
        }

        public WideEnergyStack[] createArray(int length) {
            return new WideEnergyStack[length];
        }

        @Override
        public List<WideEnergyStack> createList() {
            return Lists.newArrayList();
        }

        @Override
        public Set<WideEnergyStack> createSet() {
            return Sets.newHashSet();
        }

        @Override
        public WideEnergyStack readFrom(CompoundTag data) {
            return WideEnergyStack.from(data);
        }

        @Override
        public CompoundTag writeTo(WideEnergyStack stack, CompoundTag data) {
            return stack.serializeTo(data);
        }

        @Override
        public String toString(WideEnergyStack stack) {
            return stack.toString();
        }

        @Override
        public <T> T map(WideEnergyStack stack, Function<EnergySystem, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem());
        }

        @Override
        public <T> T map(WideEnergyStack stack, IntFunction<T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getAmount().intValue());
        }

        @Override
        public <T> T map(WideEnergyStack stack, BiFunction<EnergySystem, Integer, T> mapper, T defaultValue) {
            return stack.isEmpty() ? defaultValue : mapper.apply(stack.getEnergySystem(), stack.getAmount().intValue());
        }

        @Override
        public void accept(WideEnergyStack stack, Consumer<EnergySystem> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem());
            }
        }

        @Override
        public void accept(WideEnergyStack stack, IntConsumer consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getAmount().intValue());
            }
        }

        @Override
        public void accept(WideEnergyStack stack, BiConsumer<EnergySystem, Integer> consumer) {
            if (!stack.isEmpty()) {
                consumer.accept(stack.getEnergySystem(), stack.getAmount().intValue());
            }
        }
    };

    private StackAdapters() {
    }

    private static <StackType, ContentType> void validateNotEmpty(IStackAdapter<StackType, ContentType> adapter, StackType stack) {
        if (adapter.getEmptyStack() == stack) {
            throw new IllegalArgumentException("Attempt to modify an empty stack blocked");
        }
    }
}

